﻿<%@ Page Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Sample5.aspx.cs" Inherits="TestGroupingView.Sample5" Title="Untitled Page" %>

<%@ Register Assembly="GroupingView" Namespace="UNLV.IAP.WebControls" TagPrefix="cc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="Title" runat="server">
    Sample 5:  EmptyDataTemplate
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    Select a Region:
    <asp:DropDownList ID="dd1" runat="server" DataSourceID="sqlRegions" 
                      DataTextField="Region" DataValueField="Region"
                      AppendDataBoundItems="true"
                      AutoPostBack="true"
                      >
        <asp:ListItem text="--choose region--" Value="" />                    
    </asp:DropDownList>

    <br /><br />    

    <cc1:GroupingView ID="GroupingView1" runat="server" GroupingDataField="State"
                      DataSourceID="sqlCities"
                      >
        <EmptyDataTemplate>
            <i>Choose a region from the dropdown above.</i>
        </EmptyDataTemplate>
        
        <GroupTemplate>
            <b><%# Eval("State") %></b>
            <asp:BulletedList ID="bul1" runat="server" DataTextField="City" />
            <br />
        </GroupTemplate>
        
    </cc1:GroupingView>    
    


    <asp:SqlDataSource ID="sqlRegions" runat="server" 
        ConnectionString="<%$ ConnectionStrings:ConnectionString %>" 
        SelectCommand="SELECT Distinct Region from Cities Order by Region">        
    </asp:SqlDataSource>

    <asp:SqlDataSource ID="sqlCities" runat="server" 
        ConnectionString="<%$ ConnectionStrings:ConnectionString %>" 
        SelectCommand="SELECT State, City from Cities Where Region = @region Order by State, City"
        >     
        <SelectParameters>
            <asp:ControlParameter Name="region" ControlID="dd1" PropertyName="SelectedValue" />
        </SelectParameters>           
    </asp:SqlDataSource>


</asp:Content>

<asp:Content ID="Content4" ContentPlaceHolderID="Description" runat="server">
    Define content in the <code>EmptyDataTemplate</code> to display when the GroupingView
    contains no data.
    <br /><br />
    In this example, the EmptyDataTemplate contains literal text, instructing the user
    to select a parameter.
</asp:Content>
