﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Sample2.aspx.cs" Inherits="TestGroupingView.Sample10" MasterPageFile="~/Site.Master" %>
<%@ Register Assembly="GroupingView" Namespace="UNLV.IAP.WebControls" TagPrefix="cc1" %>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="Title">
    Sample 2:  Using the ItemTemplate to list items within a group
</asp:Content>

<asp:Content runat="server" ContentPlaceHolderID="ContentPlaceHolder1">
    
    <cc1:GroupingView ID="GroupingView1" runat="server"
                      GroupingDataField="Region"
                      DataSourceID="sql1"
                      AutobindDataSourceChildren="true"
                      >
        
        <GroupTemplate>
            <asp:Label ID="lblRegion" runat="server"
                       Text='<%# Eval("Region") %>'
                       Font-Bold="true"
                       Font-Size="Large"
                       ForeColor="ForestGreen"
                       Font-Names="Tahoma,Verdana,Arial,Sans-Serif"
                       />
            
            <table>
                <%-- group header --%>
                <tr>
                   <th width="100" align="left">City</th>
                   <th width="100" align="left">State</th>
                   <th width="100" align="right">Sales</th>
                </tr>
                
                <%-- group data items --%>
                <asp:PlaceHolder ID="itemPlaceholder" runat="server" />
                
                <%-- group footer --%>
                <tr><td colspan="3"><hr /></td></tr>
                <tr>
                    <td align="right" colspan="2">Group total:</td>
                    <td align="right">
                        <cc1:Aggregation runat="server" Function="Sum"
                                         DataField="Sales"
                                         FormatString="{0:#,##0.00}"
                                         />
                    </td>
                </tr>
                <tr>
                    <td align="right" colspan="2">Group average:</td>
                    <td align="right">
                        <cc1:Aggregation runat="server" Function="Avg"
                                         DataField="Sales"
                                         FormatString="{0:#,##0.00}"
                                         />
                    </td>
                </tr>
            </table>                
            <br /><br />                                 
        </GroupTemplate>
        
        <ItemTemplate>
            <%-- define items within a group --%>
            <tr>
                <td><%#Eval("City") %></td>
                <td><%#Eval("State") %></td>
                <td align="right"><%#Eval("Sales", "{0:#,##0.00}") %></td>
            </tr>
        </ItemTemplate>
        
    </cc1:GroupingView>
    
    Grand Total:
    <cc1:Aggregation runat="server" Function="Sum"
                     DataSourceID="sql1"
                     DataField="Sales"
                     FormatString="{0:#,##0.00}"
                     />
    <br />
    Average per city:
    <cc1:Aggregation ID="Aggregation1" runat="server" Function="Avg"
                     DataSourceID="sql1"
                     DataField="Sales"
                     FormatString="{0:#,##0.00}"
                     />
                     
            
    <asp:SqlDataSource ID="sql1" runat="server" 
        ConnectionString="<%$ ConnectionStrings:ConnectionString %>" 
        SelectCommand="SELECT * FROM [Cities] Order By Region, State, City">        
    </asp:SqlDataSource>

        
</asp:Content>

<asp:Content runat="server" ContentPlaceHolderID="Description">
    This example demonstrates the use of the <code>ItemTemplate</code> to 
    define the display for individual items within a group.  A placeholder control
    with an ID set to <code>itemPlaceholder</code> is positioned in the 
    <code>GroupTemplate</code>.  <code>Aggregation</code> controls appear in the
    <code>GroupTemplate</code> for subtotals, and below the <code>GroupingView</code>
    for grand totals.    
</asp:Content>