﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Sample1.aspx.cs" Inherits="TestGroupingView.Sample9" MasterPageFile="~/Site.Master" %>
<%@ Register Assembly="GroupingView" Namespace="UNLV.IAP.WebControls" TagPrefix="cc1" %>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="Title">
    Sample 1: Using a GridView to list items within a group
</asp:Content>


<asp:Content runat="server" ContentPlaceHolderID="ContentPlaceHolder1">

    <cc1:GroupingView ID="GroupingView1" runat="server"
                      GroupingDataField="Region"
                      AutobindDataSourceChildren="true"
                      DataSourceID="sql1"
                      >
        
        <GroupTemplate>
            <asp:Label ID="lblRegion" runat="server"
                       Text='<%# Eval("Region") %>'
                       Font-Bold="true"
                       />
            
            <asp:GridView ID="gvCities" runat="server" 
                          AutoGenerateColumns="false"
                          ShowHeader="false"
                          >
                <Columns>
                    <asp:BoundField DataField="City" />
                    <asp:BoundField DataField="State" />
                </Columns>    
            </asp:GridView> 
            <br />
            Count of cities:  
            <cc1:Aggregation runat="server" 
                             Function="Count" />                                                                         
            <br />
            <br />
            <br />                                 
        </GroupTemplate>
    </cc1:GroupingView>

        
            
    <asp:SqlDataSource ID="sql1" runat="server" 
        ConnectionString="<%$ ConnectionStrings:ConnectionString %>" 
        SelectCommand="SELECT * FROM [Cities]">        
    </asp:SqlDataSource>

</asp:Content>

<asp:Content runat="server" ContentPlaceHolderID="Description">
    This example demonstrates the use of a GridView within the <code>GroupTemplate</code>
    to list individual items within the group.  The GroupingView's 
    <code>AutobindDataSourceChildren</code> is set to <code>true</code>.  There
    is no need for an <code>itemPlaceholder</code> control in the <code>GroupTemplate</code>,
    nor is there a need for an <code>ItemTemplate</code> defined.
</asp:Content>