﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using UNLV.IAP.WebControls;

namespace TestGroupingView
{
    public partial class Items1 : System.Web.UI.Page
    {
        protected void Page_PreRender(object sender, EventArgs e)
        {
            // use a bulleted list to present our use of the Groups, Items, and NestedItems
            // properties
            BulletedList list = new BulletedList();

            // demonstrate item counts
            list.Items.Add("Count of groups (GroupingView1.Groups.Count): " + GroupingView1.Groups.Count.ToString());
            list.Items.Add("Count of total items (GroupingView1.Items.Count): " + GroupingView1.Items.Count.ToString());

            // demonstrate use of the NestedItems property for a single group
            const int kGroupIndex = 2;
            GroupingViewGroupItem group = GroupingView1.Groups[kGroupIndex];
            int cnt = group.NestedItems.Count;

            // demonstrate locating a control within the applied GroupTemplate
            // for a single group
            string region = "";
            Label lblRegion = group.FindControl("lblRegion") as Label;
            if (lblRegion != null)
                region = lblRegion.Text;

            // demonstrate iterating items from a single group
            string letters = "";
            foreach (GroupingViewItem item in GroupingView1.Groups[kGroupIndex].NestedItems)
            {
                // is this an genuine item and not a separator?
                if (item is GroupingViewItem && !(item is GroupingViewSeparatorItem))
                {
                    // locate the label in the item
                    Label lbl = item.FindControl("lblCity") as Label;
                    if (lbl != null)
                        letters += lbl.Text.Substring(0,1) + " ";
                }
            }
            
            // put all that information for the single group into bulleted list lines
            string tmpl = "items in Group index #{0} '{1}' (GroupingView1.Groups[{0}].NestedItems.Count): {2} ";
            list.Items.Add(string.Format(tmpl, kGroupIndex, region, cnt));

            tmpl = "first letters of cities in Group index #{0}: {1}";
            list.Items.Add(string.Format(tmpl, kGroupIndex, letters));                


            // display the bulleted list in the appropriate place holder
            ph1.Controls.Add(list);
        }
    }
}
