﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using UNLV.IAP.WebControls;

namespace TestGroupingView
{
    public partial class TestAggregations : System.Web.UI.Page
    {

        protected void Page_Load(object sender, EventArgs e)
        {
        }


        protected void btn1_Click(object sender, EventArgs e)
        {
            IEnumerable source = GetDataSource();
            BindAggregations(this.Controls, source);
        }

        protected IEnumerable GetDataSource()
        {
            // convert the entered text into an IEnumerable datasource
            List<double> list = new List<double>();
            string[] arr = txt1.Text.Split(new char[] { ',' });
            foreach (string s in arr)
            {
                try
                {
                    list.Add(Convert.ToDouble(s));
                }
                catch { }
            }
            
            return list;
        }

        protected void BindAggregations(ControlCollection ctrls, IEnumerable dataSource)
        {
            // bind all aggregation controls to the datasource
            foreach (Control c in ctrls)
            {
                Aggregation agg = c as Aggregation;
                if (agg != null)
                {
                    agg.DataSource = dataSource;
                    agg.DataBind();
                }
                if (c.HasControls()) 
                    BindAggregations(c.Controls, dataSource);
            }
        }


    }
}
