﻿/***************************************************
 * This code is Copyright 2008 Michael J. Ellison.  All rights reserved.
 * Usage and distribution of this code is governed by the
 * CodeProject Open License.  A copy of the license may be found
 * at:
 * http://www.codeproject.com/info/cpol10.aspx
 * **************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI;

namespace UNLV.IAP.WebControls
{
    /// <summary>
    /// Represents the container in which individual GroupTemplate items are instantiated.
    /// </summary>
    public class GroupingViewGroupItem : GroupingViewItem
    {
        /// <summary>
        /// Initializes a new instance of the <see cref="GroupingViewGroupItem" /> class.
        /// </summary>
        /// <param name="dataItem">The data item bound to this GroupingView item.</param>
        /// <param name="groupIndex">The 0-based index of this item's group among the total number of groups in the data source.</param>
        /// <param name="itemIndex">The 0-based index of this item among the total number of items in the data source.</param>
        /// <param name="itemIndexWithinGroup">The 0-based index of this item among the number of items in the parent group.</param>
        public GroupingViewGroupItem(object dataItem, int groupIndex, int itemIndex, int itemIndexWithinGroup)
            : base(dataItem, groupIndex, itemIndex, itemIndexWithinGroup) { }


        /// <summary>
        /// Gets a collection of <see cref="GroupingViewItem" /> objects 
        /// instantiated within a group
        /// in a <see cref="GroupingView" /> control.
        /// </summary>
        /// <remarks>
        /// Use the <see cref="NestedItems" /> property to examine the individual
        /// items and content controls created within a group.  This includes items
        /// created through the application of ItemTemplates and ItemSeparatorTemplates.
        /// </remarks>
        /// <example>
        /// See the <see cref="GroupingView.Groups" /> property documentation for an example
        /// of using the NestedItems property.
        /// </example>
        public GroupingViewItemCollection NestedItems
        {
            get
            {
                // items when created are stored as child controls
                GroupingViewItemCollection items = new GroupingViewItemCollection();
                AddItemsToCollection(items, this);

                return items;
            }
        }


        // recursive procedure to inspect child controls
        private void AddItemsToCollection(GroupingViewItemCollection coll, Control parent)
        {
            foreach (Control c in parent.Controls)
            {
                if (c is GroupingViewItem)
                    coll.Add(c as GroupingViewItem);

                if (c.HasControls())
                    AddItemsToCollection(coll, c);
            }
        }


    }

}
