﻿/***************************************************
 * This code is Copyright 2008 Michael J. Ellison.  All rights reserved.
 * Usage and distribution of this code is governed by the
 * CodeProject Open License.  A copy of the license may be found
 * at:
 * http://www.codeproject.com/info/cpol10.aspx
 * **************************************************/
using System;
using System.Collections.Generic;
using System.Text;

namespace UNLV.IAP.WebControls
{
    /// <summary>
    /// Specifies arguments for the following events of a <see cref="GroupingView" /> control:
    /// <see cref="GroupingView.GroupCreated">GroupCreated</see>,
    /// <see cref="GroupingView.GroupDataBound">GroupDataBound</see>,
    /// <see cref="GroupingView.ItemCreated">ItemCreated</see>,
    /// and <see cref="GroupingView.ItemDataBound">ItemDataBound</see>.
    /// </summary>
    public class GroupingViewEventArgs : EventArgs
    {
        private int _groupIndex;
        private int _itemIndex;
        private int _itemIndexWithinGroup;
        private GroupingViewItem _item;

        /// <summary>
        /// Gets the 0-based index of the group among the total number of 
        /// groups in the <see cref="GroupingView"/> control's data source.
        /// </summary>
        public int GroupIndex { get { return _groupIndex; } }


        /// <summary>
        /// Gets the 0-based index of the item among the total number of 
        /// items in the <see cref="GroupingView"/> control's data source.
        /// </summary>
        public int ItemIndex { get { return _itemIndex; } }

        /// <summary>
        /// Gets the 0-based index of the item among the number of 
        /// items of its parent group.
        /// </summary>
        public int ItemIndexWithinGroup { get { return _itemIndexWithinGroup; } }

        /// <summary>
        /// Gets the <see cref="GroupingViewItem"/> that was created or databound.
        /// </summary>
        public GroupingViewItem Item { get { return _item; } }


        /// <summary>
        /// Initializes a new instance of the <see cref="GroupingViewEventArgs" /> class.
        /// </summary>
        /// <param name="item">The associated GroupingView item that is created or databound.</param>
        /// <param name="groupIndex">The 0-based index of the item's group among the total number of groups in the data source.</param>
        /// <param name="itemIndex">The 0-based index of the item among the total number of items in the data source.</param>
        /// <param name="itemIndexWithinGroup">The 0-based index of the item among the number of items in its parent group.</param>
        public GroupingViewEventArgs(GroupingViewItem item, int groupIndex, int itemIndex, int itemIndexWithinGroup)
        {
            _item = item;
            _groupIndex = groupIndex;
            _itemIndex = itemIndex;
            _itemIndexWithinGroup = itemIndexWithinGroup;
        }

    }
}
