﻿/***************************************************
 * This code is Copyright 2008 Michael J. Ellison.  All rights reserved.
 * Usage and distribution of this code is governed by the
 * CodeProject Open License.  A copy of the license may be found
 * at:
 * http://www.codeproject.com/info/cpol10.aspx
 * **************************************************/
using System;
using System.Collections.Generic;
using System.Text;

namespace UNLV.IAP.WebControls
{
    /// <summary>
    /// Defines the signature for the following events of a <see cref="GroupingView"/>
    /// control:  
    /// <see cref="GroupingView.GroupCreated">GroupCreated</see>,
    /// <see cref="GroupingView.GroupDataBound">GroupDataBound</see>,
    /// <see cref="GroupingView.ItemCreated">ItemCreated</see>,
    /// and <see cref="GroupingView.ItemDataBound">ItemDataBound</see>.
    /// </summary>
    /// <param name="o">The GroupingView control triggering the event.</param>
    /// <param name="e">Event arguments.</param>
    public delegate void GroupingViewEventHandler(object o, GroupingViewEventArgs e);

    /// <summary>
    /// Defines the signature for the 
    /// <see cref="GroupingView.Command">Command</see>
    /// event of a <see cref="GroupingView"/> control.
    /// </summary>
    /// <param name="o">The GroupingView control triggering the event.</param>
    /// <param name="e">Event arguments.</param>
    public delegate void GroupingViewCommandEventHandler(object o, GroupingViewCommandEventArgs e);
}
