﻿/***************************************************
 * This code is Copyright 2008 Michael J. Ellison.  All rights reserved.
 * Usage and distribution of this code is governed by the
 * CodeProject Open License.  A copy of the license may be found
 * at:
 * http://www.codeproject.com/info/cpol10.aspx
 * **************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI.WebControls;

namespace UNLV.IAP.WebControls
{
    /// <summary>
    /// Provides arguments for a <see cref="GroupingView.Command"/> event handler.
    /// </summary>
    public class GroupingViewCommandEventArgs : CommandEventArgs
    {
        private GroupingViewTemplateEnum _template;

        /// <summary>
        /// The type of template in which the command-triggering control is located.
        /// </summary>
        public GroupingViewTemplateEnum CommandTemplate
        {
            get { return _template; }
        }

        /// <summary>
        /// Initializes a new instance of the <see cref="GroupingViewCommandEventArgs" /> class.
        /// </summary>
        /// <param name="e">Command arguments bubbled up from a child control.</param>
        /// <param name="template">The template in which the child control command was initiated.</param>
        public GroupingViewCommandEventArgs(CommandEventArgs e, GroupingViewTemplateEnum template) : base(e)
        {
            _template = template;
        }
    }
}
