﻿/***************************************************
 * This code is Copyright 2008 Michael J. Ellison.  All rights reserved.
 * Usage and distribution of this code is governed by the
 * CodeProject Open License.  A copy of the license may be found
 * at:
 * http://www.codeproject.com/info/cpol10.aspx
 * **************************************************/
namespace UNLV.IAP.WebControls
{
    /// <summary>
    /// Enumerates the aggregation operations available for use with the
    /// <see cref="Aggregation" /> control.
    /// </summary>
    public enum AggregationFunction
    {
        /// <summary>
        /// Counts the number of items in the assigned datasource
        /// </summary>
        Count,

        /// <summary>
        /// Returns the sum of the <see cref="Aggregation.DataField">DataField</see>
        /// values in the assigned datasource
        /// </summary>
        Sum,

        /// <summary>
        /// Returns the lowest of the <see cref="Aggregation.DataField">DataField</see>
        /// values in the assigned datasource
        /// </summary>
        Min,

        /// <summary>
        /// Returns the highest of the <see cref="Aggregation.DataField">DataField</see>
        /// values in the assigned datasource
        /// </summary>
        Max,

        /// <summary>
        /// Returns the first of the <see cref="Aggregation.DataField">DataField</see>
        /// values in the assigned datasource
        /// </summary>
        First,

        /// <summary>
        /// Returns the last of the <see cref="Aggregation.DataField">DataField</see>
        /// values in the assigned datasource
        /// </summary>
        Last,

        /// <summary>
        /// Returns the average (statistical mean) of the <see cref="Aggregation.DataField">DataField</see>
        /// values in the assigned datasource
        /// </summary>
        Avg,

        /// <summary>
        /// Returns the statistical median (distribution midpoint) 
        /// of the <see cref="Aggregation.DataField">DataField</see>
        /// values in the assigned datasource
        /// </summary>
        Median,


        /// <summary>
        /// Returns the statistical variance of the <see cref="Aggregation.DataField">DataField</see>
        /// values in the assigned datasource
        /// </summary>
        Var,

        /// <summary>
        /// Returns the standard deviation of the <see cref="Aggregation.DataField">DataField</see>
        /// values in the assigned datasource
        /// </summary>
        StDev
    }
}