﻿/***************************************************
 * This code is Copyright 2008 Michael J. Ellison.  All rights reserved.
 * Usage and distribution of this code is governed by the
 * CodeProject Open License.  A copy of the license may be found
 * at:
 * http://www.codeproject.com/info/cpol10.aspx
 * **************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel.Design;

namespace UNLV.IAP.WebControls
{
    /// <summary>
    /// Provides designer support for the Aggregation control by defining 
    /// supported designer actions
    /// </summary>
    public class AggregationDesignerActionList : DesignerActionList
    {

        private DesignerActionUIService _designerActionUISvc;
        private AggregationDesigner _controlDesigner;

        /// <summary>
        /// Initializes a new instance of the <see cref="AggregationDesignerActionList" /> class.
        /// </summary>
        /// <param name="designer">The associated designer.</param>
        public AggregationDesignerActionList(AggregationDesigner designer)
            : base(designer.Component)
        {
            _designerActionUISvc = GetService(typeof(DesignerActionUIService)) as DesignerActionUIService;
            _controlDesigner = designer;
        }

        /// <summary>
        /// Gets or sets the <see cref="Aggregation.DataField">DataField</see> value for
        /// the <see cref="Aggregation" /> control in a designer context.
        /// </summary>
        public string DataField
        {
            get { return _controlDesigner.DataField; }
            set { _controlDesigner.DataField = value; RefreshAll(); }
        }

        /// <summary>
        /// Gets or sets the <see cref="Aggregation.Function">Function</see> value for
        /// the <see cref="Aggregation" /> control in a designer context.
        /// </summary>
        public AggregationFunction Function
        {
            get { return _controlDesigner.Function; }
            set { _controlDesigner.Function = value; RefreshAll(); }
        }

        /// <summary>
        /// Refreshes the display
        /// </summary>
        private void RefreshAll()
        {
            _controlDesigner.UpdateDesignTimeHtml();
            _designerActionUISvc.Refresh(_controlDesigner.Component);
        }

        /// <summary>
        /// Returns the list of designer actions associated with an
        /// <see cref="Aggregation"/> control.
        /// </summary>
        /// <returns>The list of actions.</returns>
        public override DesignerActionItemCollection GetSortedActionItems()
        {
            DesignerActionItemCollection col = new DesignerActionItemCollection();

            DesignerActionPropertyItem pi = new DesignerActionPropertyItem(
                "DataField", "Data Field:", ""
                );
            pi.AllowAssociate = true;
            col.Add(pi);

            pi = new DesignerActionPropertyItem(
                "Function", "Function:", ""
                );
            pi.AllowAssociate = true;
            col.Add(pi);

            return col;
        }

    }
}
