﻿/***************************************************
 * This code is Copyright 2008 Michael J. Ellison.  All rights reserved.
 * Usage and distribution of this code is governed by the
 * CodeProject Open License.  A copy of the license may be found
 * at:
 * http://www.codeproject.com/info/cpol10.aspx
 * **************************************************/
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;
using System.Data;
using System.Web.UI;
using System.Web.UI.Design;
using System.Web.UI.Design.WebControls;
using System.ComponentModel.Design;
using System.ComponentModel;
using System.Text.RegularExpressions;
using System.IO;



namespace UNLV.IAP.WebControls
{
    /// <summary>
    /// Provides designer support for the Aggregation control.
    /// </summary>
    public class AggregationDesigner : DataBoundControlDesigner
    {

        /// <summary>
        /// Gets the component being designed typed as an <see cref="Aggregation"/> control.
        /// </summary>
        public Aggregation ComponentControl
        {
            get { return (Component as Aggregation); }
        }

        /// <summary>
        /// Gets or sets the <see cref="Aggregation.DataField">DataField</see> value for
        /// the <see cref="Aggregation" /> control in a designer context.
        /// </summary>
        public string DataField
        {
            get { return ComponentControl.DataField; }
            set { ComponentControl.DataField = value; }
        }

        /// <summary>
        /// Gets or sets the <see cref="Aggregation.Function">Function</see> value for
        /// the <see cref="Aggregation" /> control in a designer context.
        /// </summary>
        public AggregationFunction Function
        {
            get { return ComponentControl.Function; }
            set { ComponentControl.Function = value; }
        }

        /// <summary>
        /// Initializes the designer
        /// </summary>
        /// <param name="component">The component to design</param>
        public override void Initialize(System.ComponentModel.IComponent component)
        {
            base.Initialize(component);
            if (!(component is Aggregation))
                throw new ArgumentException("Component must be an Aggregation to use an AggregationDesigner");
        }

        /// <summary>
        /// Returns the actions associated with this designer.
        /// </summary>
        public override System.ComponentModel.Design.DesignerActionListCollection ActionLists
        {
            get
            {
                DesignerActionListCollection col = base.ActionLists;
                col.Add(new AggregationDesignerActionList(this));
                return col;
            }
        }

        /// <summary>
        /// Returns the html markup for the control in a design-time environment.
        /// </summary>
        /// <returns>The html markup.</returns>
        public override string GetDesignTimeHtml()
        {

            string func = string.Format("{0}({1})"
                   , Enum.GetName(typeof(AggregationFunction), this.Function)
                   , this.DataField
                   );

            StringWriter sw = new StringWriter();
            HtmlTextWriter writer = new HtmlTextWriter(sw);
            ComponentControl.RenderBeginTag(writer);
            writer.Write(func);
            ComponentControl.RenderEndTag(writer);

            return sw.ToString();
        }

    
        /// <summary>
        /// Assigns the DataFieldConverter type converter to the DataField property.
        /// </summary>
        /// <param name="properties"></param>
        protected override void PreFilterProperties(IDictionary properties)
        {

            base.PreFilterProperties(properties);
            Attribute[] attributes = new Attribute[] { new TypeConverterAttribute(typeof(DataFieldConverter)) };
            PropertyDescriptor oldPropertyDescriptor = (PropertyDescriptor)properties["DataField"];
            oldPropertyDescriptor = TypeDescriptor.CreateProperty(this.GetType(), oldPropertyDescriptor, attributes);
            properties["DataField"] = oldPropertyDescriptor;

        }


    }
}
