using System.IO;

namespace CodeProjectExample
{
	/// <summary>
	/// Various file related utility functions
	/// </summary>
	public static class FileUtil
	{
	
	#region :: Class Functions ::

		/// <summary>
		/// Injects a postfix after the filename but before the extension.
		/// </summary>
		/// <param name="fileName">The name/path of the file</param>
		/// <param name="postfix">The postfix</param>
		public static string InjectPostfix(string fileName, string postfix)
		{
			return InjectPostfix(fileName, postfix, false);
		}
		//--------------------------------------------------------------------------
		/// <summary>
		/// Injects a postfix after the filename but before the extension.
		/// </summary>
		/// <param name="fileName">The name/path of the file</param>
		/// <param name="postfix">The postfix</param>
		/// <param name="onlyIfNotPresent">Only apply the post fix if its not already there</param>
		public static string InjectPostfix(string fileName, string postfix, bool onlyIfNotPresent)
		{
			var fileNameNoExt = Path.GetFileNameWithoutExtension(fileName);

			if (onlyIfNotPresent && fileNameNoExt.EndsWith(postfix))
			{
				return fileName;
			}

			return Path.Combine(
				Path.GetDirectoryName(fileName),
				string.Concat(
					fileNameNoExt,
					postfix,
					Path.GetExtension(fileName))
				);
		}
		//--------------------------------------------------------------------------
		/// <summary>
		/// Removes a postfix after the filename but before the extension.
		/// </summary>
		/// <param name="fileName">The name/path of the file</param>
		/// <param name="postfix">The postfix</param>
		public static string RemovePostfix(string fileName, string postfix)
		{
			return Path.Combine(
				Path.GetDirectoryName(fileName),
				string.Concat(
					Path.GetFileNameWithoutExtension(fileName).Replace(postfix, string.Empty),
					Path.GetExtension(fileName))
				);
		}
		
	#endregion
		
	}
		
}
