using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Summary description for Class1
/// </summary>
/// 
namespace MyVote
{
    public class Voting : WebControl,INamingContainer 
    {
        private string voteNumber;
        private int iStarCount = 3;
        private string overImageUrl;
        private string outImageUrl;

        private ImageButton im;

        public event EventHandler Click;


        public string VoteCount
        {
            get { return voteNumber; }
            set { voteNumber = value; }
        }

        public string MouseOver_ImagePath
        {
            get { return overImageUrl; }
            set { overImageUrl = value; }
        }


        public string MouseOut_ImagePath
        {
            get { return outImageUrl; }
            set { outImageUrl = value; }
        }

        public int StarCount
        {
            get { return iStarCount; }
            set { iStarCount = value; }
        }

        protected override bool  OnBubbleEvent(object source, EventArgs e)
        {

            if (e is CommandEventArgs)
            {
                CommandEventArgs ce = (CommandEventArgs)e;
                if (ce.CommandName == "Click")
                {
                    VoteCount  = ce.CommandArgument.ToString();
                   
                    OnClick(ce);

                }

            }
            return true;
        }

        protected virtual void OnClick(EventArgs e)
        {
            if (Click != null)
            {
                Click(this, e);
            }
        }

      
        protected override void CreateChildControls()
        {
           
                  for (int i = 1; i < StarCount + 1; i++)
                    {
                        im = new ImageButton();

                        im.ImageUrl = MouseOut_ImagePath ;

                        im.Attributes.Add("onmouseover", "this.src='" + MouseOver_ImagePath + "';");
                        im.Attributes.Add("onmouseout", "this.src='" + MouseOut_ImagePath + "';");
                        im.AlternateText = i.ToString();
                        im.ID = "but" + i.ToString();
                        im.CommandName = "Click";
                        im.CommandArgument = i.ToString();
                        Controls.Add(im);
                        
                    }
                }
            }
        }
  