﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.IO;

namespace TestGroupingView
{
    public partial class Site : System.Web.UI.MasterPage
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            AdjustMenuItemLinks();
        }

        protected void AdjustMenuItemLinks()
        {
            // inspect the current page and compare to the menu items
            // to hilite the item corresponding to the current page
            string current = Server.MapPath(Request.Url.AbsolutePath).ToLower();
            foreach (Control c in phMenuItems.Controls)
            {
                HyperLink h = c as HyperLink;
                if (h != null)
                {
                    if (Server.MapPath(h.NavigateUrl).ToLower() == current)
                        h.CssClass = "on";
                    else
                        h.CssClass = "";

                }
            }
        }
    }
}
