﻿<%@ Page Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Sample4.aspx.cs" Inherits="TestGroupingView.Sample4" Title="Untitled Page" %>

<%@ Register Assembly="GroupingView" Namespace="UNLV.IAP.WebControls" TagPrefix="cc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>

<asp:Content ID="Content2" ContentPlaceHolderID="Title" runat="server">
    Sample 4:  Limiting Autobinding to certain template controls
</asp:Content>

<asp:Content ID="Content3" ContentPlaceHolderID="ContentPlaceHolder1" runat="server">

    <cc1:GroupingView ID="GroupingView1" runat="server" 
                      DataSourceID="sql1"
                      GroupingDataField="Region"
                      AutobindDataSourceChildren="true"   
                      AutobindInclusions="bulList1"                   
                      >
        <GroupTemplate>
            Actions for <%#Eval("Region") %>:
            <asp:DropDownList ID="dd1" runat="server">
                <asp:ListItem text="Review Sales" />
                <asp:ListItem text="Display Employees" />
                <asp:ListItem text="Do something else" />
            </asp:DropDownList>
            <br />
            <br />
            <asp:BulletedList ID="bulList1" runat="server" DataTextField="City" />
        </GroupTemplate>   
         
    </cc1:GroupingView>
    
    <asp:SqlDataSource ID="sql1" runat="server" 
        ConnectionString="<%$ ConnectionStrings:ConnectionString %>" 
        SelectCommand="SELECT * FROM [Cities] Order By Region, State, City">        
    </asp:SqlDataSource>

</asp:Content>


<asp:Content ID="Content4" ContentPlaceHolderID="Description" runat="server">
If the <code>AutobindDataSourceChildren</code> property of a <code>GroupingView</code>
control is set to <code>true</code>, then all controls with a <code>DataSource</code>
property in the <code>GroupTemplate</code> are automatically bound to the group's data
subset.  This provides a convenient way to list items, using for example a <code>GridView</code>.
<br />
<br />
There may be occasions when you wish to limit the controls that are automatically bound
this way.  Use either the <code>AutobindInclusions</code> or <code>AutobindExclusions</code>
property of the <code>GroupingView</code> control in conjunction with 
<code>AutobindDataSourceChildren</code>=<code>true</code> to control this behavior.
<br /><br />
In this example, <code>AutobindInclusions</code> is used to specify the <code>BulletedList</code>
control as the one to bind.  The <code>DropDownList</code> control for the group is left 
alone.
</asp:Content>
