﻿<%@ Page Language="C#" MasterPageFile="~/Site.Master" AutoEventWireup="true" CodeBehind="Sample3.aspx.cs" Inherits="TestGroupingView.Sample3" Title="GroupingView Examples" %>

<%@ Register Assembly="GroupingView" Namespace="UNLV.IAP.WebControls" TagPrefix="cc1" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="server">
</asp:Content>

<asp:Content ContentPlaceHolderID="Title" runat="server">
    Sample 3:  Nesting GroupingView Controls
</asp:Content>

<asp:Content ContentPlaceHolderID="ContentPlaceHolder1" runat="server">
    
  <div class="hierarchical">
    <cc1:GroupingView ID="gvMainGroupings" runat="server" 
                      DataSourceID="sql1" GroupingDataField="Region" 
                      OnGroupDataBound="gvMainGroupings_GroupDataBound">
        <GroupTemplate>
            <ul>
                <li>
                    <asp:Label ID="lblGroupIndex" runat="server" />
                    <%# Eval("Region") %>
                    <cc1:GroupingView ID="gvSecondaryGroupings" runat="server"
                                      GroupingDataField="State">
                        <GroupTemplate>
                            <ul>
                                <li>
                                    <%# Eval("State") %>
                                    <asp:BulletedList runat="server" DataTextField="City" />
                                </li>
                            </ul>
                        </GroupTemplate>
                    </cc1:GroupingView>
                </li>
            </ul>
        </GroupTemplate>        
    </cc1:GroupingView>
  </div>
  
    <asp:SqlDataSource ID="sql1" runat="server" 
        ConnectionString="<%$ ConnectionStrings:ConnectionString %>" 
        SelectCommand="SELECT * FROM [Cities] Order By Region, State, City">        
    </asp:SqlDataSource>

</asp:Content>

<asp:Content ContentPlaceHolderID="Description" runat="server">
    This example demonstrates the nesting of a <code>GroupingView</code> in the
    <code>GroupTemplate</code> of a parent to provide a secondary grouping in the
    display of the data.  Note that the data source is still a flat table with
    fields defining the primary and secondary groupings, rather than 
    a hierarchical data structure.
    <br /><br />
    This example also demonstrates a handler for the <code>GroupDataBound</code> event.
    The handler assigns the group index to the left of the group name.
</asp:Content>
