﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Items1.aspx.cs" Inherits="TestGroupingView.Items1"  
         MasterPageFile="~/Site.Master"%>

<%@ Register Assembly="GroupingView" Namespace="UNLV.IAP.WebControls" TagPrefix="cc1" %>

<asp:Content ID="Content0" runat="server" ContentPlaceHolderID="Title">
    Groups, Items, and NestedItems properties
</asp:Content>

<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="ContentPlaceHolder1">

    <div class="itemExample">
        <cc1:GroupingView ID="GroupingView1" runat="server" GroupingDataField="Region"
                          DataSourceID="sql1"
                          >
                          
            <GroupTemplate>
                <b><asp:Label ID="lblRegion" runat="server" Text='<%# Eval("Region") %>' /></b>
                <br />
                <asp:PlaceHolder ID="itemPlaceholder" runat="server" />
                <br />
                <br />
            </GroupTemplate>                          
            
            <ItemTemplate>
                <asp:Label ID="lblCity" runat="server" Text='<%#Eval("City") %>' />
                &nbsp;
            </ItemTemplate>
            
        </cc1:GroupingView>
        <hr />
        
        <asp:PlaceHolder ID="ph1" runat="server" />
            
        <asp:SqlDataSource ID="sql1" runat="server" 
            ConnectionString="<%$ ConnectionStrings:ConnectionString %>" 
            SelectCommand="SELECT * FROM [Cities]">        
        </asp:SqlDataSource>

    </div>

</asp:Content>

<asp:Content ID="Content2" runat="server" ContentPlaceHolderID="Description">
    The GroupingView exposes the <code>Groups</code> and <code>Items</code>
    properties to access the items created from templates and their content controls.
    <br />
    <br />
    The <code>Groups</code> property returns a <code>GroupingViewGroupItemCollection</code>
    containing distinct group items typed as <code>GroupingViewGroupItem</code> objects.
    These objects expose the <code>NestedItems</code> property which contain items and
    separators created within the group.
    <br />
    <br />
    The <code>Items</code> property returns a more generic <code>GroupingViewItemCollection</code>
    containing all items created for the <code>GroupingView</code>, regardless of the
    template from which the item was created.  This represents the total number of groups,
    items, and separators created within the GroupingView.  The order of the collection
    matches the order the items were created; for example, the first GroupTemplate applied will
    be present as the first item in the <code>Items</code> collection.  If the group contains
    items (applied through the <code>ItemTemplate</code> property), those come next in the <code>Items</code> order.
    Separator items (<code>GroupSeparatorTemplate</code>, <code>ItemSeparatorTemplate</code>) are also included.
    <br />
    <br />
    This example demonstrates the use of <code>Groups</code>, <code>Items</code>, 
    and <code>NestedItems</code> properties to inspect
    the contents of items created within the GroupingView.
</asp:Content>


