﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Commands1.aspx.cs" Inherits="TestGroupingView.Commands1" MasterPageFile="~/Site.Master"%>

<%@ Register Assembly="GroupingView" Namespace="UNLV.IAP.WebControls" TagPrefix="cc1" %>


<asp:Content ID="Content1" runat="server" ContentPlaceHolderID="Title">
    Command Handling
</asp:Content>

<asp:Content runat="server" ContentPlaceHolderID="ContentPlaceHolder1">
    <asp:Label ID="lblMessage" runat="server" />
    <div class="CommandExample">
        <cc1:GroupingView ID="GroupingView1" runat="server" AutobindChildren="True" 
            DataSourceID="SqlDataSource1" GroupingDataField="Region" 
            ItemPlaceholderID="itemPlaceholder" oncommand="GroupingView1_Command"             
            >
            
            <GroupTemplate>
                <asp:Button ID="btn1" runat="server" Text='<%#Eval("Region").ToString().Trim()%>'
                            CommandName="Region" 
                            CommandArgument='<%# Eval("Region") %>'
                            />                            
                <ul style="margin-top: 2px; margin-bottom: 34px;">
                    <asp:PlaceHolder ID="itemPlaceholder" runat="server" />
                </ul>                            
            </GroupTemplate>
            
            <ItemTemplate>
                <li>
                    <asp:LinkButton ID="hl1" runat="server"
                                    Text='<%# Eval("City") %>'
                                    CommandName="City"
                                    CommandArgument='<%# Eval("City") + "|" + Eval("State") + "|" + Eval("Region") %>'
                                   />, 
                    <asp:LinkButton ID="hl2" runat="server"
                                    Text='<%# Eval("State") %>'
                                    CommandName="State"
                                    CommandArgument='<%#Eval("State") + "|" + Eval("Region") %>'
                                   />
                </li>
            </ItemTemplate>
            
        </cc1:GroupingView>
        
        
        <asp:SqlDataSource ID="SqlDataSource1" runat="server" 
            ConnectionString="<%$ ConnectionStrings:ConnectionString %>" 
            SelectCommand="SELECT * FROM [Cities]">
        </asp:SqlDataSource>
    </div>
</asp:Content>

<asp:Content runat="server" ContentPlaceHolderID="Description">
    This example demonstrates a handler for the <code>Command</code> event
    of the <code>GroupingView</code>.  Button controls represent the regions
    and LinkButton controls represent cities and states, each with a <code>CommandName</code>
    <code>CommandArgument</code> set for availability to the event handler.
</asp:Content>