﻿/***************************************************
 * This code is Copyright 2008 Michael J. Ellison.  All rights reserved.
 * Usage and distribution of this code is governed by the
 * CodeProject Open License.  A copy of the license may be found
 * at:
 * http://www.codeproject.com/info/cpol10.aspx
 * **************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI;

namespace UNLV.IAP.WebControls
{

    /// <summary>
    /// Represents the container in which individual ItemTemplate items are instantiated.
    /// </summary>
    public class GroupingViewItem : Control, IDataItemContainer
    {
        private object _dataItem;
        private int _groupIndex;
        private int _itemIndex;
        private int _itemIndexWithinGroup;


        /// <summary>
        /// Initializes a new instance of the <see cref="GroupingViewItem" /> class.
        /// </summary>
        /// <param name="dataItem">The data item bound to this GroupingView item.</param>
        /// <param name="groupIndex">The 0-based index of this item's group among the total number of groups in the data source.</param>
        /// <param name="itemIndex">The 0-based index of this item among the total number of items in the data source.</param>
        /// <param name="itemIndexWithinGroup">The 0-based index of this item among the number of items in the parent group.</param>
        public GroupingViewItem(object dataItem, int groupIndex, int itemIndex, int itemIndexWithinGroup)
        {
            _dataItem = dataItem;
            _groupIndex = groupIndex;
            _itemIndex = itemIndex;
            _itemIndexWithinGroup = itemIndexWithinGroup;
        }


        #region IDataItemContainer Members

        /// <summary>
        /// Gets the data item associated with the <see cref="GroupingViewItem" />.
        /// </summary>
        public object DataItem
        {
            get { return _dataItem; }
        }

        /// <summary>
        /// Gets the 0-based index of the data item among the total number of items
        /// in the data source.
        /// </summary>
        public int DataItemIndex
        {
            get { return _itemIndex; }
        }

        /// <summary>
        /// Gets the 0-based index of the data item among the total number of items
        /// in the data source.
        /// </summary>
        public int DisplayIndex
        {
            get { return _itemIndex; }
        }

        /// <summary>
        /// Gets the 0-based index of the data item's group among the total number
        /// of groups in the data source.
        /// </summary>
        public int GroupIndex
        {
            get { return _groupIndex; }
        }

        /// <summary>
        /// Gets the 0-based index of the data item among the total number of items
        /// in the data source.
        /// </summary>
        public int ItemIndex
        {
            get { return _itemIndex; }
        }

        /// <summary>
        /// Gets the 0-based index of the data item among the total number of items
        /// in its parent group.
        /// </summary>
        public int ItemIndexWithinGroup
        {
            get { return _itemIndexWithinGroup; }
        }

        #endregion
    }
}
