﻿/***************************************************
 * This code is Copyright 2008 Michael J. Ellison.  All rights reserved.
 * Usage and distribution of this code is governed by the
 * CodeProject Open License.  A copy of the license may be found
 * at:
 * http://www.codeproject.com/info/cpol10.aspx
 * **************************************************/
using System;
using System.Collections.Generic;
using System.Text;
using System.ComponentModel.Design;
using System.Web.UI.Design;
using System.ComponentModel;

namespace UNLV.IAP.WebControls
{
    /// <summary>
    /// Provides a list of design-time actions for a <see cref="GroupingView" /> control.
    /// </summary>
    public class GroupingViewDesignerActionList : DesignerActionList
    {

        private DesignerActionUIService _designerActionUISvc;
        private GroupingViewDesigner _controlDesigner;

        /// <summary>
        /// Initializes a new instance of the <see cref="GroupingViewDesignerActionList" />
        /// class.
        /// </summary>
        /// <param name="designer">The designer associated with this action list.</param>
        public GroupingViewDesignerActionList(GroupingViewDesigner designer)
            : base(designer.Component)
        {
            _designerActionUISvc = GetService(typeof(DesignerActionUIService)) as DesignerActionUIService;
            _controlDesigner = designer;
        }

        /// <summary>
        /// Gets or sets the <see cref="GroupingView.GroupingDataField">GroupingDataField</see>
        /// property value for the designed <see cref="GroupingView" /> control.
        /// </summary>
        public string GroupingDataField
        {
            get { return _controlDesigner.GroupingDataField; }
            set { _controlDesigner.GroupingDataField = value; RefreshAll(); }
        }

        /// <summary>
        /// Updates the display for the design-time component.
        /// </summary>
        private void RefreshAll()
        {
            _controlDesigner.UpdateDesignTimeHtml();
            _designerActionUISvc.Refresh(_controlDesigner.Component);
        }


        /// <summary>
        /// Provides the designer with a collection of actions.
        /// </summary>
        /// <returns></returns>
        public override DesignerActionItemCollection GetSortedActionItems()
        {
            DesignerActionItemCollection col = new DesignerActionItemCollection();

            DesignerActionPropertyItem pi = new DesignerActionPropertyItem(
                "GroupingDataField", "Grouping Data Field:", ""
                );
            pi.AllowAssociate = true;
            col.Add(pi);

            return col;
        }

    }
}
