﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Smum County Modal Form Demo</title>
    
    <script type="text/javascript">
        function UpdateContact()
        {
            //Move the data from the modal form controls to the display only controls on the main form.
            //Note that this routine could be an AJAX call to communicate pass the entered data to the server.

            var firstName = document.getElementById("ModalFirstName");
            if (firstName != null) firstName = firstName.value;

            var lastName = document.getElementById("ModalLastName");
            if (lastName != null) lastName = lastName.value;

            var phone = document.getElementById("ModalOfficePhone");
            if (phone != null) phone = phone.value;

            var email = document.getElementById("ModalEmailAddress");
            if (email != null) email = email.value;
            
            var span = document.getElementById("ContactName");
            if (span != null) span.innerHTML = firstName + " " + lastName;
            
            span = document.getElementById("OfficePhone");
            if (span != null) span.innerHTML = phone;
            
            span = document.getElementById("EmailAddress");
            if (span != null) span.innerHTML = email;
        }
    </script>
</head>
<body style="font-family: Verdana; font-size:11px; background-color:#B0C4DE">
    <form id="form1" runat="server">    
        <asp:ScriptManager ID="ScriptManager1" runat="server"/>
        
        <div style="">
            Contact Name: <span id="ContactName"></span><br />
            Office Phone: <span id="OfficePhone"></span><br />
            Email Address: <span id="EmailAddress"></span><br /><br />
            <asp:LinkButton runat="server" ID="cmdContactInfo">Edit Contact</asp:LinkButton>
        </div>
        
        <sc:ModalForm ID="ContactForm" runat="server" Width="300px" Title="Enter a new contact" CancelControlID="cmdContactCancel" OkControlId="cmdContactOk" OnOkScript="UpdateContact()" ActivateControlId="cmdContactInfo" CloseImage="ModalClose.gif" CloseRolloverImage="ModalCloseRO.gif">
            <table>
                <tr>
                    <td>First Name</td>
                    <td><asp:TextBox ID="ModalFirstName" runat="server"></asp:TextBox></td>
                </tr>
                <tr>
                    <td>Last Name</td>
                    <td><asp:TextBox ID="ModalLastName" runat="server"></asp:TextBox></td>
                </tr>
                <tr>
                    <td>Office Phone</td>
                    <td><asp:TextBox ID="ModalOfficePhone" runat="server"></asp:TextBox></td>
                </tr>
                <tr>
                    <td>Email Address</td>
                    <td><asp:TextBox ID="ModalEmailAddress" runat="server"></asp:TextBox></td>
                </tr>
            </table>
            
            <asp:LinkButton ID="cmdContactOk" runat="server">OK</asp:LinkButton>
            <asp:LinkButton ID="cmdContactCancel" runat="server">Cancel</asp:LinkButton>    
        </sc:ModalForm>
    </form>
</body>
</html>
