/// <summary>
/// Close a modal form when the close window icon in the upper right is pressed.
/// </summary>
/// <param name="closeCommandId">
/// This is the id of the control that should be clicked to close the modal form.
/// </param>
function ModalFormClose(closeCommandId)
{
    var closeCommand = document.getElementById(closeCommandId);
    
    if (closeCommand != null)
    {
        //IE and Mozilla must be handled differently.
        if (closeCommand.click)
        {
            //IE simply supports a click method which we can call on the closeCommand.
            closeCommand.click();
        }
        else
        {
            var evt = closeCommand.ownerDocument.createEvent("MouseEvents");
            evt.initMouseEvent('click', true, true, closeCommand.ownerDocument.defaultView, 1, 0, 0, 0, 0, false, false, false, false, 0, null);
            closeCommand.dispatchEvent(evt);         
        }
    }
}

/// <summary>
/// Change an image because of a mouse rollover.
/// </summary>
/// <param name="e">
/// Event argument.
/// </param>
function RolloverImage(e)
{
    try
    {
        e = e || window.event;
        
        var image;
        if (e.srcElement)
            image = e.srcElement;
        else
            image = e.target;
        
        //var image = $(Event.element(e));

        //Separate the source into a path and a file name.
        var sourcePath = GetPath(image.src);
        
        if (e.type == 'mouseout')
            image.src = sourcePath + image.getAttribute('image');
        else
            image.src = sourcePath + image.getAttribute('rolloverImage');
    }
    catch (ex) 
    {
        alert("Error occurred: [RolloverImage]\n\n" + ex.message);
    } 
}

/// <summary>
/// Return just the path of a path and file string.
/// </summary>
/// <param name="pathAndFile">
/// </param>
function GetPath(pathAndFile)
{
    var index = pathAndFile.lastIndexOf('/');
    if (index > -1)
        return pathAndFile.substring(0, index + 1);
    else
        return "";
}

