﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Microsoft.Live.ServerControls.VE;

namespace CodeProjectVirtualEarth
{
    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            // Glasgow Caledonian University
            AddShape(55.8662120997906, -4.25060659646988,
                "<b>Glasgow Caledonian University</b>");

            // Dundee University
            AddShape(56.4572643488646, -2.97848381102085,
                "<b>Dundee University</b>");

            // Microsoft Edinburgh (George Street)
            AddShape(55.9525336325169, -3.20506207644939,
                "<b>Microsoft Edinburgh</b> (George Street)");

            // Microsoft Edinburgh (Waterloo Place)
            AddShape(55.9535374492407, -3.18680360913277,
                "<b>Microsoft Edinburgh</b> (Waterloo Place)");
        }

        private void AddShape(double latitude, double longitude, string description)
        {
            LatLongWithAltitude point = new LatLongWithAltitude(latitude, longitude);
            Shape shape = new Shape(ShapeType.Pushpin, point);
            shape.Description = description;
            shape.CustomIcon = "images/target.png";
            VEMap.AddShape(shape);
        }
    }
}
