﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using AjaxControlToolkit;

namespace RealtimeReorderlist
{
    public partial class RealtimeReorderList : System.Web.UI.Page
    {
        protected int NewListOrderNumber;
        protected List<ReorderListItem> ListDataItems;

        protected void Page_Load(object sender, EventArgs e)
        {

            rlItemList.ItemReorder += new EventHandler<ReorderListItemReorderEventArgs>(rlItemList_ItemReorder);

            // Event handler for deleting items from the list
            rlItemList.ItemCommand += new EventHandler<ReorderListCommandEventArgs>(rlItemList_ItemCommand);

            GetListData();
            if (!Page.IsPostBack)
                BindData();
        }


        /// <summary>
        /// Reorder list items in the database when a reorder event occurs
        /// </summary>
        protected void rlItemList_ItemReorder(object sender, ReorderListItemReorderEventArgs e)
        {
            var NewOrder = e.NewIndex + 1;
            var OldOrder = e.OldIndex + 1;

            var ReorderListItemID = Convert.ToInt32(((Label)(e.Item.FindControl("ID"))).Text);

            var db = new RealTimeReorderListDataDataContext();

            var ListItemCount = 1;

            var ListData = from ld in db.ReorderListItems
                           orderby ld.ListOrder
                           select ld;
            foreach (var ListDataItem in ListData)
            {
                // Move forward items in this range
                if (OldOrder > NewOrder
                    && ListItemCount >= NewOrder
                    && ListItemCount <= OldOrder
                    )
                    ListDataItem.ListOrder = ListItemCount + 1;
                // Move backward items in this range
                else if
                    (OldOrder < NewOrder
                    && ListItemCount <= NewOrder
                    && ListItemCount >= OldOrder
                    )
                    ListDataItem.ListOrder = ListItemCount - 1;

                ListItemCount++;

                // Set the changed item into the newly numerical gap
                if (ListDataItem.ID == ReorderListItemID)
                    ListDataItem.ListOrder = NewOrder;
            }

            db.SubmitChanges();

            GetListData();
            BindData();
        }


        /// <summary>
        /// ItemCommand event used to delete list items
        /// </summary>
        void rlItemList_ItemCommand(object sender, ReorderListCommandEventArgs e)
        {
            // If you want support for multiple commands
            if (e.CommandName != "Delete")
                return;

            var db = new RealTimeReorderListDataDataContext();

            var ListData = from ld in db.ReorderListItems
                           where ld.ID == Convert.ToInt32(((Label)(e.Item.FindControl("ID"))).Text)
                           select ld;
            db.ReorderListItems.DeleteAllOnSubmit(ListData);
            db.SubmitChanges();
            GetListData();
            BindData();
        }


        /// <summary>
        /// Add button click event used to inset a new list item into the database
        /// </summary>
        protected void AddReorderListItem_Click(object sender, EventArgs e)
        {
            GetListData(); // Get the current NewListOrderNumber
            var db = new RealTimeReorderListDataDataContext();
            var RLI = new ReorderListItem
            {
                ListOrder = NewListOrderNumber,
                Name = tbItemName.Text,
                Description = tbItemDescription.Text
            };
            db.ReorderListItems.InsertOnSubmit(RLI);
            db.SubmitChanges();

            // Clear the form values so that watermark shows
            tbItemName.Text = "";
            tbItemDescription.Text = "";

            GetListData(); //Get the list with the newly inserted item
            BindData();

        }

        /// <summary>
        /// Retrieve the list items from the database
        /// </summary>
        protected void GetListData()
        {
            var db = new RealTimeReorderListDataDataContext();
            var ListData = from ld in db.ReorderListItems
                           orderby ld.ListOrder
                           select ld;
            ListDataItems = ListData.ToList();
            NewListOrderNumber = ListDataItems.Count() + 1;
        }

        /// <summary>
        /// Bind the data the to the ReorderList control
        /// </summary>
        protected void BindData()
        {
            rlItemList.DataSource = ListDataItems;
            rlItemList.DataBind();
        }

    }
}
