﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="RealtimeReorderList.aspx.cs"
    Inherits="RealtimeReorderlist.RealtimeReorderList" %>

<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <link rel="Stylesheet" type="text/css" href="ReorderList.css" />
    <title>Realtime Reorderable List Using LINQ to SQL</title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <asp:ScriptManager ID="ScriptManager1" runat="server" />
        <asp:UpdatePanel ID="UpdatePanel1" runat="server">
            <ContentTemplate>
                <fieldset>
                    <legend>Reorderable List Items</legend>
                    <div style="width: 850px">
                        <div class="reorderListDemo" style="padding-bottom: 50px">
                            <ajaxToolkit:ReorderList ID="rlItemList" DragHandleAlignment="Left" PostBackOnReorder="true"
                                CallbackCssStyle="callbackStyle" ItemInsertLocation="End" ShowInsertItem="false"
                                runat="server">
                                <DragHandleTemplate>
                                    <div class="dragHandle">
                                    </div>
                                </DragHandleTemplate>
                                <ItemTemplate>
                                    <div class="itemArea">
                                        <span style="float: right">
                                            <asp:Button Width="50" ID="Button3" CommandName="Delete" runat="server" Text="Delete" />
                                        </span>
                                        <asp:Label ID="ID" Visible="false" runat="server" Text='<%# Eval("ID") %>'></asp:Label>
                                        <asp:Label ID="Order" Visible="false" runat="server" Text='<%# Eval("ListOrder") %>'></asp:Label>
                                        <asp:Label ID="Name" runat="server" Text='<%# Eval("Name") %>'></asp:Label>: &nbsp;
                                        <asp:Label ID="Label1" runat="server" Text='<%# Eval("Description") %>'></asp:Label>
                                    </div>
                                </ItemTemplate>
                                <ReorderTemplate>
                                    <asp:Panel ID="Panel2" runat="server" CssClass="reorderCue" />
                                </ReorderTemplate>
                            </ajaxToolkit:ReorderList>
                        </div>
                    </div>
                </fieldset>
                <fieldset>
                    <legend>Add List Item</legend>
                    <div>
                        <asp:TextBox ID="tbItemName" runat="server"></asp:TextBox>
                        <ajaxToolkit:TextBoxWatermarkExtender ID="TBWE1" runat="server" TargetControlID="tbItemName"
                            WatermarkText="Name" WatermarkCssClass="watermarkTextBox" />
                    </div>
                    <div>
                        <asp:TextBox Rows="4" ID="tbItemDescription" runat="server" Height="51px" TextMode="MultiLine"></asp:TextBox>
                        <ajaxToolkit:TextBoxWatermarkExtender ID="TBWE2" runat="server" TargetControlID="tbItemDescription"
                            WatermarkText="Description" WatermarkCssClass="watermarkTextBox" />
                    </div>
                    <div>
                        <asp:Button ID="btnAddReorderListItem" runat="server" Text="Add" OnClick="AddReorderListItem_Click" />
                    </div>
                </fieldset>
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
    </form>
</body>
</html>
