using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.Design;

namespace SmartDirectoryServer
{
    [DefaultProperty("Text")]
    [ToolboxData("<{0}:EmbeddedObject runat=server></{0}:EmbeddedObject>")]
    public class EmbeddedObject : WebControl
    {
        private class FlashVariable
        {
            public string Name;
            public string Value;

            public FlashVariable(string name, string value)
            {
                Name = name;
                Value = value;
            }
        }

        private string mFilePath;
        private List<FlashVariable> FlashVariables = new List<FlashVariable>();

        [Browsable(true)]
        [Description("Set path to SWF source file.")]
        public string FilePath
        {
            get { return mFilePath; }
            set { mFilePath= value; }
        }

        public void AddVariable(string name, string value)
        {
            FlashVariables.Add(new FlashVariable(name,value));
        }

        protected override void RenderContents(HtmlTextWriter writer)
        {
             try
             {
                 StringBuilder sb = new StringBuilder();
                 string flashVariableString = "";

                 foreach (FlashVariable fv in FlashVariables)
                     flashVariableString += fv.Name + "=" + fv.Value + "&";
                 if (FlashVariables.Count > 0)
                    flashVariableString = flashVariableString.Substring(0, flashVariableString.Length - 1);

                 sb.Append("<object classid=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" ");
                 sb.Append("codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=5,0,2,0\" ID=Moshe Width=" + Width.Value.ToString() + " Height=" + Height.Value.ToString() + " > ");
                 sb.Append("<param name=movie value=\"" + FilePath.ToString() + "\"> ");
                 sb.Append("<param name=FlashVars value=\"" + flashVariableString + "\">");
                 sb.Append("<param name=quality value=high> ");
                 sb.Append("<param name=BGCOLOR value=#FFFFFF>");
                 sb.Append("<embed src=\"" + FilePath.ToString() + "\" ");
                 sb.Append("pluginspage=\"http://www.macromedia.com/shockwave/download/index.cgi?P1_Prod_Version=ShockwaveFlash\" type=\"application/x-shockwave-flash\" ");
                 sb.Append("Width = " + Width.Value.ToString() + " ");
                 sb.Append("Height = " + Height.Value.ToString() + " ");
                 sb.Append("bgcolor=#FFFFFF ");
                 sb.Append("FlashVars=\""+ flashVariableString + "\" ");
                 sb.Append("TYPE=\"application/x-shockwave-flash\" ");
                 sb.Append("><embed></object>");
                 writer.Write(sb.ToString());
             }
             catch(Exception ex)
             {
                 writer.RenderBeginTag(HtmlTextWriterTag.Div);
                 writer.Write("Custom Flash Control");
                 writer.RenderEndTag();
             }            
        }
    }
}
