using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Resources;
using System.Diagnostics;

namespace ColorPickerLib
{

    [ToolboxData("<{0}:ColoerPickerPalate runat=server></{0}:ColoerPickerPalate>")]
    internal class ColorPickerPalate : CompositeControl
    {

        internal ColorPickerPalate(Control control)
        {
            _Page = control.Page;
            _Control = control; 
        }

        private Control _Control = null;
        private Page _Page = null;


        protected override object SaveControlState()
        {
            object[] state = new object[2];
            // save states
            state[0] = this._Page;
            state[1] = this._Control;

            return state;
        }
        protected override void LoadControlState(object savedState)
        {
            object[] stateTmp = (object[])savedState;
            //load the state back
            this._Page = (Page)stateTmp[0];
            this._Control = (Control)stateTmp[1];

        }

        private Control RenderTable()
        {
            Table table = new Table();

            this.BuildDesign();            

            int onrow = 1;
            int oncol = 1;
            int count = 1;
            string s = "";
            string set1 = "";
            string set2 = "";
            for (int r = 5; r >= 0; r--)
            {
                for (int g = 5; g >= 0; g--)
                {
                    for (int b = 5; b >= 0; b--)
                    {
                        if (oncol == 1) s += "<tr>\n";
                        s += "\t<td onmouseover=\"colorOver(this);\" onclick=\"colorClick(this);\" style=\"cursor:pointer;background:#" + ReturnHex(r) + ReturnHex(g) + ReturnHex(b) + ";\" class=cc></td>\n";
                        oncol++;
                        if (oncol >= 19)
                        {
                            s += "</tr>\n";
                            oncol = 1;

                            if (onrow % 2 == 0)
                            {
                                set2 += s;
                            }
                            else
                            {
                                set1 += s;
                            }
                            s = "";
                            onrow++;
                        }
                        count++;
                    }
                }
            }
            _Colors.Text = "<table cellpadding=0 cellspacing=1 style=\"background:#ffffff;\" border=0 >" + set1 + set2 + "</table>";

            TableRow header = new TableRow();
            TableCell cellHeader = new TableCell();
            
            TableRow rowTop = new TableRow();
            TableCell cellTop = new TableCell();

            ResourceManager rm = new ResourceManager(
                                    this.GetType().Namespace + ".ResourceColor",
                                    this.GetType().Assembly);

            Table littleChina = new Table();
            // little china
            TableRow chinaRow = new TableRow();

            TableCell chinaCellPrev = new TableCell();
            
            chinaCellPrev.Controls.Add(new LiteralControl("\t" + rm.GetString("previewDiv")));
                        
            chinaRow.Cells.Add(chinaCellPrev);

            littleChina.Rows.Add(chinaRow);
            //end

            cellHeader.Controls.Add(littleChina);
            // add the row
            header.Cells.Add(cellHeader);

            cellTop.Controls.Add(_Colors);
            rowTop.Cells.Add(cellTop);

            table.Rows.Add(header);
            table.Rows.Add(rowTop);

            return table;
        }

        protected override void Render(HtmlTextWriter writer)
        {
            base.Render(writer);
        }

        protected override void RenderContents(HtmlTextWriter writer)
        {
            RenderTable().RenderControl(writer);
        }

        private LiteralControl _Colors = null;       
        protected override void  CreateChildControls()
        {
            this.BuildDesign();

            int onrow = 1;
            int oncol = 1;
            int count = 1;
            string s = "";
            string set1 = "";
            string set2 = "";
            for (int r = 5; r >= 0; r--)
            {
                for (int g = 5; g >= 0; g--)
                {
                    for (int b = 5; b >= 0; b--)
                    {
                        if (oncol == 1) s += "<tr>\n";
                        s += "\t<td onmouseover=\"colorOver(this);\" onclick=\"colorClick(this);\" style=\"cursor:pointer;background-color:" + ReturnHex(r) + ReturnHex(g) + ReturnHex(b) + ";\" class=\"cc\"></td>\n";
                        oncol++;
                        if (oncol >= 19)
                        {
                            s += "</tr>\n";
                            oncol = 1;

                            if (onrow % 2 == 0)
                            {
                                set2 += s;
                            }
                            else
                            {
                                set1 += s;
                            }
                            s = "";
                            onrow++;
                        }
                        count++;
                    }
                }
            }
            _Colors.Text = "<table cellpadding=0 cellspacing=1 style=\"background-color:ffffff;\" border=0 >" + set1 + set2 + "</table>";

            this.Controls.Add(_Colors);

            base.CreateChildControls();
        }

        private string ReturnHex(int i)
        {
            switch (i)
            {
                default:
                case 0:
                    return "00";
                case 1:
                    return "33";
                case 2:
                    return "66";
                case 3:
                    return "99";
                case 4:
                    return "CC";
                case 5:
                    return "FF";
            }
        }

        private void BuildDesign()
        {
            _Colors = new LiteralControl();
        }
    }
}
