using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Web.UI.HtmlControls;
using System.Reflection;
using System.Drawing;
using System.Diagnostics;

namespace ColorPickerLib
{
    [DebuggerStepThrough()]
    [ToolboxBitmap(typeof(ColorPicker), "Color.bmp")]
    [DefaultProperty("ControlToSet")]
    [ToolboxData("<{0}:ColorPicker runat=server></{0}:ColorPicker>")]
    public class ColorPicker : CompositeControl
    {

        private string _ToolTipStyle = string.Empty;

        public string GetWebResourceUrl(Page page, string resourceName)
        {
            return page.ClientScript.GetWebResourceUrl(this.GetType(), this.GetType().Namespace + "." + resourceName);
        }

        private TextBox _Control = null;

        [Browsable(true)]
        [Category("Behavior")]
        [DesignerSerializationVisibility(DesignerSerializationVisibility.Content)] 
        [PersistenceMode(PersistenceMode.Attribute)]
        public TextBox ControlToSet
        {
            set
            {
                _Control = value;
            }
            get
            {
                if (_Control == null)
                {
                    _Control = new TextBox();
                }
                return _Control;
            }
        }
        protected override object SaveControlState()
        {
            object[] state = new object[1];
            // save states
            state[0] = this._Control;

            return state;
        }
        protected override void LoadControlState(object savedState)
        {
            object[] stateTmp = (object[])savedState;
            //load the state back
            this._Control = (TextBox)stateTmp[0];
        }

        private HyperLink _Link = null;

        protected override void CreateChildControls()
        {
            _Link = new HyperLink();
            _Link.ImageUrl = this.GetWebResourceUrl(Page, "sel.gif");

            _Link.NavigateUrl = "#"; //"javascript:" + Page.ClientScript.GetPostBackEventReference(this, argument); ; 

            base.Controls.Add(_Link);

            if (!base.DesignMode)
            {
            
                ClientScriptManager cs = Page.ClientScript;

                cs.RegisterClientScriptInclude("popscript", cs.GetWebResourceUrl(this.GetType(), "ColorPickerLib.default.js"));

                _ToolTipStyle = cs.GetWebResourceUrl(this.GetType(), "ColorPickerLib.toolTipStyle.css");

                
                string csslink = "<link href='" + _ToolTipStyle + "' rel='stylesheet' type='text/css' />";
                LiteralControl include = new LiteralControl(csslink);

                Page.Header.Controls.Add(include);
            }

            base.CreateChildControls();
        }

        private string CreateColorTemlate()
        {
            StringWriter builder = new StringWriter();

            Html32TextWriter writer = new Html32TextWriter(builder);

            ColorPickerPalate details = new ColorPickerPalate(this);

            details.RenderControl(writer);

            builder.Close();

            string popup = builder.ToString();
            popup = popup.Replace("\r", string.Empty);
            popup = popup.Replace("\n", string.Empty);
            popup = popup.Replace("\t", string.Empty);

            popup = HttpUtility.HtmlEncode(popup);
            return popup;
        }

        public Control FindControlRecursive(Control Root, string Id)
        {
            if (Root.ID == Id)
                return Root;

            foreach (Control Ctl in Root.Controls)
            {
                Control FoundCtl = FindControlRecursive(Ctl, Id);

                if (FoundCtl != null)

                    return FoundCtl;

            }
            return null;
        }

        protected override void Render(HtmlTextWriter writer)
        {
            string docSource = string.Empty; //"theForm."+ this.Parent.ClientID + "_" + _Source;		
            string formID = string.Empty;

            if (!base.DesignMode)
            {

                try
                {
                    TextBox controlToFind = null;

                    if (this.Page.Master != null)
                    {

                        controlToFind = FindControlRecursive(this.Page.Master, _Control.ID) as TextBox;
                    }
                    else
                    {
                        controlToFind = FindControlRecursive(this.Page, _Control.ID) as TextBox;
                    }


                    docSource = controlToFind.ClientID;

                    string popup = CreateColorTemlate();

                    _Link.Attributes.Add("onclick", "showDiv( 'windowContent','" + docSource + "', \"" + popup + "\")");
                }
                catch
                {
                    throw new Exception("ControlToSet Property can not be left blank");
                }
            }
            HtmlGenericControl div = new HtmlGenericControl("div");

            div.ID = "windowContent";
            div.Style.Add(HtmlTextWriterStyle.Visibility, "hidden");
            div.Style.Add(HtmlTextWriterStyle.Display, "none");
          
            //render
            div.RenderControl(writer);

            base.Render(writer);
        }    
    }
}
