using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class DEMO__HiddenHyperlinks : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {

        string pageNumberQS = Request.QueryString[pager1.QueryStringParameterName] ?? string.Empty;
        if (pageNumberQS != string.Empty && Convert.ToInt32(pageNumberQS) > 0)
        {
            pager1.CurrentIndex = Convert.ToInt32(pageNumberQS);
            BindRepeater();
        }

        if (!Page.IsPostBack)
        {

            BindRepeater();
        }

    }


    public void pager_Command(object sender, CommandEventArgs e)
    {
        int currnetPageIndx = Convert.ToInt32(e.CommandArgument);
        pager1.CurrentIndex = currnetPageIndx;
        BindRepeater();
    }

    private void BindRepeater()
    {

        string strConn = ConfigurationManager.ConnectionStrings["northwindConnectionString"].ConnectionString;
        SqlConnection cn = new SqlConnection(strConn);

        // Change StoredProcedure name if you've changed its name OR you are using the SqlServer_2000 StoredProcedure
        SqlCommand Cmd = new SqlCommand("dbo.GetPagedProducts_sql2k5", cn);
        Cmd.CommandType = CommandType.StoredProcedure;
        SqlDataReader dr;


        Cmd.Parameters.Add("@PageSize", SqlDbType.Int, 4).Value = pager1.PageSize;
        Cmd.Parameters.Add("@CurrentPage", SqlDbType.Int, 4).Value = pager1.CurrentIndex;
        Cmd.Parameters.Add("@ItemCount", SqlDbType.Int).Direction = ParameterDirection.Output;

        cn.Open();
        dr = Cmd.ExecuteReader();

        rptProducts.DataSource = dr;
        rptProducts.DataBind();

        dr.Close();
        cn.Close();

        Int32 _totalRecords = Convert.ToInt32(Cmd.Parameters["@ItemCount"].Value);
        pager1.ItemCount = _totalRecords;


    }

}
