USE Northwind
GO

CREATE PROCEDURE [dbo].[GetPagedProducts_sql2k5]
	@PageSize int,
	@CurrentPage int,
	@ItemCount int output
AS

	Declare @UpperBand int, @LowerBand int
	
	-- Get The Count Of The Rows That They Meet the Criteria
	SET @ItemCount = (SELECT COUNT(*) FROM Products)

	-- Calculate the @LowerCount and @UpperCount
	SET @LowerBand  = (@CurrentPage - 1) * @PageSize
	SET @UpperBand  = (@CurrentPage * @PageSize) + 1


	;WITH tempPagedProducts AS
	(SELECT ProductId, ProductName, CategoryId,
	ROW_NUMBER() OVER (order by productid) as RowNumber
	FROM Products )


	SELECT * 
	FROM tempPagedProducts 
	WHERE RowNumber > @LowerBand AND RowNumber < @UpperBand

RETURN