USE Northwind
GO

CREATE PROCEDURE [dbo].[GetPagedProducts_sql2k]
(
	@PageSize int,
	@CurrentPage int,
	@ItemCount int output
)
AS
	Declare @UpperBand int, @LowerBand int
	
	-- Get The Count Of The Rows That They Meet the Criteria
	SET @ItemCount = (SELECT COUNT(*) FROM Products)

	-- Calculate the @LowerCount and @UpperCount
	SET @LowerBand  = (@CurrentPage - 1) * @PageSize
	SET @UpperBand  = (@CurrentPage * @PageSize) + 1

	-- create a temporaty table
	CREATE TABLE #AllRows(
	RowNumber int PRIMARY KEY IDENTITY(1, 1),
	ProductName nvarchar(40),
	CategoryID int
	)

	-- INSERT ALL THE Rows that meets the Criteria
	INSERT INTO #AllRows
	SELECT ProductName, CategoryID
	FROM Products
	ORDER BY ProductName ASC

	-- AND finally select and return desired -Paged- Rows
	SELECT RowNumber, ProductName, CategoryID
	FROM #AllRows
	WHERE RowNumber > @LowerBand AND RowNumber < @UpperBand


	RETURN