﻿Public Partial Class DEMO_LINQ
    Inherits System.Web.UI.Page

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        If (Not Page.IsPostBack) Then
            BindRepeater()
        End If
    End Sub

    Public Sub pager_command(ByVal sender As Object, ByVal e As CommandEventArgs)
        Dim currnetPageIndx As Int32 = CType(e.CommandArgument, Int32)
        pager1.CurrentIndex = currnetPageIndx
        BindRepeater()
    End Sub

    Public Sub BindRepeater()
        Dim db As New NorthwindDataContext

        Dim skip As Int32 = (pager1.CurrentIndex - 1) * pager1.PageSize
        Dim take As Int32 = pager1.PageSize

        Dim appliedQuery As IEnumerable(Of Product)
        appliedQuery = From p In db.Products _
                       Select p

        Dim results As IEnumerable(Of Product) = appliedQuery.Skip(skip).Take(take)
        pager1.ItemCount = appliedQuery.Count()

        rptProducts.DataSource = results.Select(Function(p As Product, i As Integer) _
                New With {.ProductName = p.ProductName, .RowNumber = 1 + i + ((pager1.CurrentIndex - 1) * pager1.PageSize)})
        rptProducts.DataBind()

    End Sub


    Public Sub btnTest_click(ByVal sender As Object, ByVal e As EventArgs)
        Dim btnSender As Button = CType(sender, Button)
        If (btnSender.CommandName = "postback") Then

            Response.Write("postBack occured.")
            BindRepeater()

        ElseIf (btnSender.CommandName = "ps70") Then

            pager1.PageSize = 70
            BindRepeater()

        Else

            pager1.PageSize = 15
            BindRepeater()


        End If

    End Sub
End Class