﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace DEMO_PagerControlV2_8netFx3_5_CS
{
    public partial class LINQ : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!IsPostBack)
            {
                BindRepeater();
            }
        }

        public void pager_Command(object sender, CommandEventArgs e)
        {
            int currnetPageIndx = Convert.ToInt32(e.CommandArgument);
            pager1.CurrentIndex = currnetPageIndx;
            BindRepeater();
        }

        private void BindRepeater()
        {

            NorthwindDataContext db = new NorthwindDataContext();

            int skip = (pager1.CurrentIndex - 1) * pager1.PageSize;
            int take = pager1.PageSize;

            IEnumerable<Product> appliedQuery = db.Products;

            IEnumerable<Product> results = appliedQuery.Skip(skip).Take(take);

            pager1.ItemCount = appliedQuery.Count();

            rptProducts.DataSource = results.Select((p, i) => new { ProductName = p.ProductName, RowNumber = 1 + i + ((pager1.CurrentIndex - 1) * pager1.PageSize) });

            rptProducts.DataBind();

        }

        protected void btnTest_click(object s, EventArgs e)
        {
            Button btnSender = s as Button;
            if (btnSender.CommandName == "postback")
            {
                Response.Write("postBack occured.");
                BindRepeater();
            }
            else if (btnSender.CommandName == "ps70")
            {
                pager1.PageSize = 70;
                BindRepeater();
            }
            else
            {
                pager1.PageSize = 15;
                BindRepeater();


            }


        }

    }
}
