﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Data.SqlClient;
using System.Data;
using System.Configuration;

namespace DEMO_PagerControlV2_8netFx3_5_CS
{
    public partial class ADO_NET : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (!Page.IsPostBack)
            {
                BindRepeater();
            }
        }


        public void pager_Command(object sender, CommandEventArgs e)
        {
            int currnetPageIndx = Convert.ToInt32(e.CommandArgument);
            pager1.CurrentIndex = currnetPageIndx;
            BindRepeater();
        }

        private void BindRepeater()
        {
            string strConn = ConfigurationManager.ConnectionStrings["northwindConnectionString"].ConnectionString;
            SqlConnection cn = new SqlConnection(strConn);

            // Change StoredProcedure name if you've changed its name OR you are using the SqlServer_2000 StoredProcedure
            SqlCommand Cmd = new SqlCommand("dbo.GetPagedProducts_sql2k5", cn);
            Cmd.CommandType = CommandType.StoredProcedure;
            SqlDataReader dr;


            Cmd.Parameters.Add("@PageSize", SqlDbType.Int, 4).Value = pager1.PageSize;
            Cmd.Parameters.Add("@CurrentPage", SqlDbType.Int, 4).Value = pager1.CurrentIndex;
            Cmd.Parameters.Add("@ItemCount", SqlDbType.Int).Direction = ParameterDirection.Output;

            cn.Open();
            dr = Cmd.ExecuteReader();

            rptProducts.DataSource = dr;
            rptProducts.DataBind();

            dr.Close();
            cn.Close();

            Int32 _totalRecords = Convert.ToInt32(Cmd.Parameters["@ItemCount"].Value);
            pager1.ItemCount = _totalRecords;
        }

        protected void btnTest_click(object s, EventArgs e)
        {
            Button btnSender = s as Button;
            if (btnSender.CommandName == "postback")
            {
                Response.Write("postBack occured.");
                BindRepeater();
            }
            else if (btnSender.CommandName == "ps70")
            {
                pager1.PageSize = 70;
                BindRepeater();
            }
            else
            {
                pager1.PageSize = 15;
                BindRepeater();
            }


        }
    }
}
