using System.Web.UI;
using System.Web.UI.WebControls;

namespace DerivedControlLibrary
{
    public class DropDownListReadOnly : DropDownList
    {
        private bool _readOnly;
        public bool ReadOnly
        {
            get
            {
                return _readOnly;
            }
            set
            {
                _readOnly = value;
            }
        }

        [PersistenceModeAttribute(PersistenceMode.InnerProperty)]
        public override ListItemCollection Items
        {
            get
            {
                return base.Items;
            }
        }


            protected override void Render(HtmlTextWriter writer)
        {
            if (_readOnly && Enabled)
            {
                TextBox tb = new TextBox();
                tb.Attributes.Clear();
                if (SelectedItem != null)
                    tb.Text = SelectedItem.Text;
                foreach (string str in Attributes.Keys)
                {
                    tb.Attributes.Add(str,Attributes[str]);
                }
                tb.CopyBaseAttributes(this);
                tb.ReadOnly = true;
                //
                tb.Width = Width;
                tb.Height = Height;
                tb.ForeColor = ForeColor;
                tb.BackColor = BackColor;
                tb.Font.CopyFrom(Font);
                tb.CssClass = CssClass;
                tb.ID = ID;
                tb.RenderControl(writer);
            }
            else
                base.Render(writer);
        }
    }
}
