﻿Imports System.ComponentModel
Imports System.Text
Imports System.Web.UI
Imports System.Web.UI.WebControls

<Assembly: System.Web.ui.WebResource("Ala.UI.Controls.PopupScript.js", "text/javascript")> 

''' <summary>
''' Javascript Popup Control
''' </summary>
''' <remarks></remarks>
<ToolboxData("<{0}:PopupHyperlink runat=server></{0}:PopupHyperlink>")> _
Public Class PopupHyperlink
    Inherits HyperLink

    Public Enum EnumPopupTarget
        _blank
        _media
        _parent
        _search
        _self
        _top
    End Enum

    Private _PopupTarget As EnumPopupTarget = EnumPopupTarget._blank

    <Bindable(True), Category("Popup")> _
   Public Property PopupTarget() As EnumPopupTarget
        Get
            Return _PopupTarget
        End Get
        Set(ByVal value As EnumPopupTarget)
            _PopupTarget = value
        End Set
    End Property

    Private _PopupWidth As String

    <Bindable(True), Category("Popup")> _
    Public Property PopupWidth() As String
        Get
            Return _PopupWidth
        End Get
        Set(ByVal value As String)
            _PopupWidth = value
        End Set
    End Property

    Private _PopupHeight As String
    <Bindable(True)> _
   Public Property PopupHeight() As String
        Get
            Return _PopupHeight
        End Get
        Set(ByVal value As String)
            _PopupHeight = value
        End Set
    End Property

    Private _PopupLocation As String

    <Bindable(True), _
    Category("Popup"), _
    System.ComponentModel.EditorAttribute(GetType(System.Web.UI.Design.UrlEditor), _
                                          GetType(System.Drawing.Design.UITypeEditor))> _
    Public Property PopupLocation() As String
        Get
            Return _PopupLocation
        End Get
        Set(ByVal value As String)
            _PopupLocation = value
        End Set
    End Property

    Private _ShowMenuBar As Boolean
    <Bindable(True), _
    Category("Popup")> _
    Public Property ShowMenuBar() As Boolean
        Get
            Return _ShowMenuBar
        End Get
        Set(ByVal value As Boolean)
            _ShowMenuBar = value
        End Set
    End Property

    Private _ShowLocationBar As Boolean
    <Bindable(True), _
     Category("Popup")> _
   Public Property ShowLocationBar() As Boolean
        Get
            Return _ShowLocationBar
        End Get
        Set(ByVal value As Boolean)
            _ShowLocationBar = value
        End Set
    End Property

    Private _ShowScrollBars As Boolean
    <Bindable(True), _
    Category("Popup")> _
    Public Property ShowScrollBars() As Boolean
        Get
            Return _ShowScrollBars
        End Get
        Set(ByVal value As Boolean)
            _ShowScrollBars = value
        End Set
    End Property

    Private _ShowStatusBar As Boolean
    <Bindable(True), _
    Category("Popup")> _
    Public Property ShowStatusBar() As Boolean
        Get
            Return _ShowStatusBar
        End Get
        Set(ByVal value As Boolean)
            _ShowStatusBar = value
        End Set
    End Property

    Private _ShowTitleBar As Boolean
    <Bindable(True), _
    Category("Popup")> _
    Public Property ShowTitleBar() As Boolean
        Get
            Return _ShowTitleBar
        End Get
        Set(ByVal value As Boolean)
            _ShowTitleBar = value
        End Set
    End Property

    Private _ShowToolBar As Boolean
    <Bindable(True), _
    Category("Popup")> _
    Public Property ShowToolBar() As Boolean
        Get
            Return _ShowToolBar
        End Get
        Set(ByVal value As Boolean)
            _ShowToolBar = value
        End Set
    End Property

    Private _Resizable As Boolean
    <Bindable(True), _
    Category("Popup")> _
    Public Property Resizable() As Boolean
        Get
            Return _Resizable
        End Get
        Set(ByVal value As Boolean)
            _Resizable = value
        End Set
    End Property

    Private _FullScreen As Boolean
    <Bindable(True), _
    Category("Popup")> _
    Public Property FullScreen() As Boolean
        Get
            Return _FullScreen
        End Get
        Set(ByVal value As Boolean)
            _FullScreen = value
        End Set
    End Property

    Protected Overrides Sub AddAttributesToRender(ByVal writer As System.Web.UI.HtmlTextWriter)
        If Not String.IsNullOrEmpty(PopupLocation) Then

            Dim Location As String = Me.ResolveClientUrl(PopupLocation)
            Dim Width As String = "''", Height As String = "''"

            If Not String.IsNullOrEmpty(PopupHeight) Then
                Height = PopupHeight
            End If

            If Not String.IsNullOrEmpty(PopupWidth) Then
                Width = PopupWidth
            End If
            Dim Script As String = _
                    Popup(Location, _
                          PopupTarget, _
                          Width, _
                          Height, _
                          ShowMenuBar, _
                          ShowLocationBar, _
                          Resizable, _
                          ShowScrollBars, _
                          ShowStatusBar, _
                          ShowTitleBar, _
                          ShowToolBar, _
                          FullScreen)

            writer.AddAttribute( _
                HtmlTextWriterAttribute.Href, _
                String.Format(Script, Me.Page.ClientScript.GetPostBackEventReference(Me, "")))
        End If
        MyBase.AddAttributesToRender(writer)
    End Sub

    Public Function Popup(ByVal Path As String, _
                          ByVal target As EnumPopupTarget, _
                          ByVal width As String, _
                          ByVal height As String, _
                          ByVal menubar As Boolean, _
                          ByVal locationbar As Boolean, _
                          ByVal resizable As Boolean, _
                          ByVal scrollbars As Boolean, _
                          ByVal status As Boolean, _
                          ByVal titlebar As Boolean, _
                          ByVal toolbar As Boolean, _
                          ByVal fullscreen As Boolean) As String

        Dim strBuilder As New StringBuilder
        strBuilder.Append("JavaScript:Showpopup(")

        strBuilder.AppendFormat("'{0}'", Path)

        strBuilder.AppendFormat(",'{0}'", System.Enum.GetName(GetType(EnumPopupTarget), target))

        If String.IsNullOrEmpty(height) Then
            strBuilder.Append(",''")
        Else
            strBuilder.AppendFormat(",{0}", height)
        End If

        If String.IsNullOrEmpty(width) Then
            strBuilder.Append(",''")
        Else
            strBuilder.AppendFormat(",{0}", width)
        End If

        If menubar Then
            strBuilder.Append(",1")
        Else
            strBuilder.Append(",0")
        End If

        If locationbar Then
            strBuilder.Append(",1")
        Else
            strBuilder.Append(",0")
        End If

        If resizable Then
            strBuilder.Append(",1")
        Else
            strBuilder.Append(",0")
        End If

        If scrollbars Then
            strBuilder.Append(",1")
        Else
            strBuilder.Append(",0")
        End If

        If status Then
            strBuilder.Append(",1")
        Else
            strBuilder.Append(",0")
        End If

        If titlebar Then
            strBuilder.Append(",1")
        Else
            strBuilder.Append(",0")
        End If

        If toolbar Then
            strBuilder.Append(",1")
        Else
            strBuilder.Append(",0")
        End If

        If fullscreen Then
            strBuilder.Append(",1);")
        Else
            strBuilder.Append(",0);")
        End If
        Return strBuilder.ToString
    End Function

    Private Sub PopupHyperlink_Init(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Init
        Dim scriptLocation As String = _
                    Page.ClientScript.GetWebResourceUrl(Me.GetType, "Ala.UI.Controls.PopupScript.js")
        If Not Page.ClientScript.IsClientScriptIncludeRegistered("PopupControl") Then
            Page.ClientScript.RegisterClientScriptInclude("PopupControl", scriptLocation)
        End If
    End Sub

End Class
