using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;

public partial class SlideShow : System.Web.UI.UserControl
{
    //This is Click event defenition for SlideShow control.
    public event SlideShowClick Click;

    /// <summary>
    /// The no. of visible images.
    /// </summary>
    private int _NoOfVisibleImages = 1;
    public int NoOfVisibleImages
    {
        get { return _NoOfVisibleImages; }
        set { _NoOfVisibleImages = value < 1 ? 1 : value; }
    }

    /// <summary>
    /// The height of the image.
    /// </summary>
    private int _ImageHeight = 0;
    public int ImageHeight
    {
        get { return _ImageHeight; }
        set { _ImageHeight = value; }
    }

    /// <summary>
    /// The width of the image.
    /// </summary>
    private int _ImageWidth = 0;
    public int ImageWidth
    {
        get { return _ImageWidth; }
        set { _ImageWidth = value; }
    }

    /// <summary>
    /// The image item collection.
    /// </summary>
    private ImageItems _Items = null;
    public ImageItems ImageDataSource
    {
        get { return _Items; }
        set { _Items = value; }
    }

    /// <summary>
    /// Path of the left arrow image.
    /// </summary>
    private string _LeftImage = string.Empty;
    public string LeftImage
    {
        get { return _LeftImage; }
        set { _LeftImage = value; }
    }

    /// <summary>
    /// Path of the right arrow image.
    /// </summary>
    private string _RightImage = string.Empty;
    public string RightImage
    {
        get { return _RightImage; }
        set { _RightImage = value; }
    }

    /// <summary>
    /// Tool Tip for the left arrow image.
    /// </summary>
    private string _LeftArrowToolTip = string.Empty;
    public string LeftArrowToolTip
    {
        get { return _LeftArrowToolTip; }
        set { _LeftArrowToolTip = value; }
    }

    /// <summary>
    /// Tool Tip for the right arrow image.
    /// </summary>
    private string _RightArrowToolTip = string.Empty;
    public string RightArrowToolTip
    {
        get { return _RightArrowToolTip; }
        set { _RightArrowToolTip = value; }
    }

    /// <summary>
    /// Title for the user control.
    /// </summary>
    private string _Title = string.Empty;
    public string Title
    {
        get { return _Title; }
        set { _Title = value; }
    }

    /// <summary>
    /// Horizontal alignment for the navigation arrows.
    /// </summary>
    private HorizontalAlign _ArrowAlign = HorizontalAlign.NotSet;
    public HorizontalAlign ArrowAlign
    {
        get { return _ArrowAlign; }
        set { _ArrowAlign = value; }
    }

    /// <summary>
    /// Horizontal alignment for the user control title.
    /// </summary>
    private HorizontalAlign _TitleAlign = HorizontalAlign.NotSet;
    public HorizontalAlign TitleAlign
    {
        get { return _TitleAlign; }
        set { _TitleAlign = value; }
    }

    /// <summary>
    /// Speed of the Slid Show in miliseconds. Default value for it is 10 miliseconds.
    /// </summary>
    private int _SlideShowSpeed = 10;
    public int SlideShowSpeed
    {
        get { return _SlideShowSpeed; }
        set { _SlideShowSpeed = value; }
    }

    /// <summary>
    /// Specifies whether to enable Click Event or not. Default value for it is false.
    /// </summary>
    private bool _EnableImageClick = false;
    public bool EnableImageClick
    {
        get { return _EnableImageClick; }
        set { _EnableImageClick = value; }
    }

    /// <summary>
    /// Methos for page load event.
    /// </summary>
    /// <param name="sender">Reference of the object that raises this event.</param>
    /// <param name="e">Contains information regarding page load event data.</param>
    protected void Page_Load(object sender, EventArgs e)
    {
        pnlParent.CssClass = "Parent";
        pnlParent.Attributes["oncontextmenu"] = "return false;";

        pnlTitle.HorizontalAlign = _TitleAlign;
        lblTitle.Text = string.IsNullOrEmpty(_Title) ? "Slide Show" : _Title;

        pnlBase.CssClass = "Base";
        pnlBase.Width = Unit.Pixel(_NoOfVisibleImages * (_ImageWidth + 1));
        pnlBase.Height = Unit.Pixel(_ImageHeight + 1);

        pnlNavigation.HorizontalAlign = _ArrowAlign;

        dataList.DataSource = _Items;
        dataList.DataBind();

        aLeft.Attributes["href"] = aRight.Attributes["href"] = "#";

        aLeft.Attributes["onmouseover"] = "javascript:Start();MoveLeft();";
        aLeft.Attributes["onmouseout"] = "javascript:Stop();StopMoveLeft();";
        aRight.Attributes["onmouseover"] = "javascript:Start();MoveRight();";
        aRight.Attributes["onmouseout"] = "javascript:Stop();StopMoveRight();";

        aLeft.ImageUrl = _LeftImage;
        aRight.ImageUrl = _RightImage;

        aLeft.ToolTip = string.IsNullOrEmpty(_LeftArrowToolTip) ? "Move Left" : _LeftArrowToolTip;
        aRight.ToolTip = string.IsNullOrEmpty(_RightArrowToolTip) ? "Move Right" : _RightArrowToolTip;

        //Adding a stylesheet to the page header
        ((HtmlHead)this.Page.Header).Controls.Add(new LiteralControl(GetCSS()));

        //Register client side script.
        this.Page.ClientScript.RegisterStartupScript(typeof(Page), "MyScript", GetJS());
    }

    protected void dataList_ItemCreated(object sender, DataListItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {
            ImageButton imgSlideShow = (ImageButton)e.Item.FindControl("imgSlideShow");
            imgSlideShow.Height = Unit.Pixel(_ImageHeight);
            imgSlideShow.Width = Unit.Pixel(_ImageWidth);

            if (_EnableImageClick)
                imgSlideShow.Click += new ImageClickEventHandler(imgSlideShow_Click);
            else
                imgSlideShow.Attributes["onclick"] = "javascript:return false;";
        }
    }

    /// <summary>
    /// This method is used to generate CSS code for this user control.
    /// </summary>
    /// <returns>CSS as a string object.</returns>
    private string GetCSS()
    {
        StringBuilder CSS = new StringBuilder();

        CSS.Append("<style type=\"text/css\">\n");

        CSS.Append(".Base\n");
        CSS.Append("{\n");
        CSS.Append("background-color: Transparent;\n");
        CSS.Append("border: 0;\n");
        CSS.Append("position: relative;\n");
        CSS.Append("overflow: hidden;\n");
        CSS.Append("}\n");

        CSS.Append(".Parent\n");
        CSS.Append("{\n");
        CSS.Append("border-style:solid;\n");
        CSS.Append("border-width:1px;\n");
        CSS.Append("}\n");

        CSS.Append("</style>");

        return CSS.ToString();
    }

    /// <summary>
    /// This method is used to generate JS code for this user control.
    /// </summary>
    /// <returns>JS as a string object.</returns>
    private string GetJS()
    {
        StringBuilder JS = new StringBuilder();

        JS.Append("<script type=\"text/javascript\">\n");

        JS.Append("var IsPaused=false;\n");
        JS.Append("var pix = 0;\n");
        JS.AppendFormat("var divWidth = {0};\n", _Items.Count * (_ImageWidth + 1));
        JS.AppendFormat("var divVirtualWidth = {0};\n", _NoOfVisibleImages * (_ImageWidth + 1));

        JS.Append("function Start()\n");
        JS.Append("{\n");
        JS.Append("IsPaused = false;\n");
        JS.Append("}\n");

        JS.Append("function Stop()\n");
        JS.Append("{\n");
        JS.Append("IsPaused = true;\n");
        JS.Append("}\n");

        JS.Append("function MoveLeft()\n");
        JS.Append("{\n");
        JS.Append("if( IsPaused || pix == -(divWidth - divVirtualWidth)) return;\n");
        JS.AppendFormat("var objtbl = document.getElementById('{0}');\n", tblBase.ClientID);
        JS.Append("pix = parseInt(objtbl.style.left.replace(\"px\",\"\"));\n");
        JS.Append("pix = pix - 1;\n");
        JS.Append("objtbl.style.left=pix.toString() + \"px\";\n");
        JS.AppendFormat("setTimeout(\"MoveLeft()\",\"{0}\");\n", _SlideShowSpeed);
        JS.Append("}\n");

        JS.Append("function StopMoveLeft()\n");
        JS.Append("{\n");
        JS.AppendFormat("if( !IsPaused || pix % {0} == 0) return;\n", _ImageWidth + 1);
        JS.AppendFormat("var objtbl = document.getElementById('{0}');\n", tblBase.ClientID);
        JS.Append("pix = parseInt(objtbl.style.left.replace(\"px\",\"\"));\n");
        JS.Append("pix = pix - 1;\n");
        JS.Append("objtbl.style.left=pix.toString() + \"px\";\n");
        JS.AppendFormat("setTimeout(\"StopMoveLeft()\",\"{0}\");\n", _SlideShowSpeed);
        JS.Append("}\n");

        JS.Append("function MoveRight()\n");
        JS.Append("{\n");
        JS.Append("if( IsPaused || pix == 0) return;\n");
        JS.AppendFormat("var objtbl = document.getElementById('{0}');\n", tblBase.ClientID);
        JS.Append("pix = parseInt(objtbl.style.left.replace(\"px\",\"\"));\n");
        JS.Append("pix = pix + 1;\n");
        JS.Append("objtbl.style.left=pix.toString() + \"px\";\n");
        JS.AppendFormat("setTimeout(\"MoveRight()\",\"{0}\");\n", _SlideShowSpeed);
        JS.Append("}\n");

        JS.Append("function StopMoveRight()\n");
        JS.Append("{\n");
        JS.AppendFormat("if(!IsPaused || pix % {0} == 0) return;\n", _ImageWidth + 1);
        JS.AppendFormat("var objtbl = document.getElementById('{0}');\n", tblBase.ClientID);
        JS.Append("pix = parseInt(objtbl.style.left.replace(\"px\",\"\"));\n");
        JS.Append("pix = pix + 1;\n");
        JS.Append("objtbl.style.left=pix.toString() + \"px\";\n");
        JS.AppendFormat("setTimeout(\"StopMoveRight()\",\"{0}\");\n", _SlideShowSpeed);
        JS.Append("}\n");

        JS.Append("</script>");

        return JS.ToString();
    }

    protected void imgSlideShow_Click(object sender, ImageClickEventArgs e)
    {
        // Fire the event.
        if (Click != null)
            Click(this, new SlideShowImageEventArgs((ImageButton)sender, e.X, e.Y));
    }
}

public class ImageItem
{
    private string _ToolTip = string.Empty;
    public string ToolTip
    {
        get { return _ToolTip; }
        set { _ToolTip = value; }
    }

    private string _URL = string.Empty;
    public string URL
    {
        get { return _URL; }
        set { _URL = value; }
    }

    // Default constructor.
    public ImageItem()
    { }

    public ImageItem(string ToolTip, string URL)
    {
        this._ToolTip = ToolTip;
        this._URL = URL;
    }
}

public class ImageItems : List<ImageItem>
{
    public ImageItems()
    { }
}

public class SlideShowImageEventArgs : EventArgs
{
    private ImageButton _ImageButton = null;
    private int _X = 0;
    private int _Y = 0;

    public int X
    {
        get { return _X; }
    }

    public int Y
    {
        get { return _Y; }
    }

    public string URL
    {
        get { return _ImageButton.ImageUrl; }
    }

    public string ToolTip
    {
        get { return _ImageButton.ToolTip; }
    }

    public SlideShowImageEventArgs(ImageButton O, int X, int Y)
    {
        _ImageButton = O;
        _X = X;
        _Y = Y;
    }
}

//Delegate that represents the Click event signature for SlideShow control.
public delegate void SlideShowClick(object sender, SlideShowImageEventArgs e);
