﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<%@ Register Assembly="iucon.web.Controls.PartialUpdatePanel" Namespace="iucon.web.Controls"
    TagPrefix="iucon" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>PartialUpdatePanel Demo Page</title>
    <link href="StyleSheet.css" rel="stylesheet" type="text/css" />
</head>
<body>
    <form id="form1" runat="server">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
    <div>
        <table border="0" cellspacing="10">
            <tr>
                <td>
                    <h1>
                        Control PostBack sample</h1>
                    <div class="sample">
                        <iucon:PartialUpdatePanel runat="server" ID="Panel1" UserControlPath="~/PostBackSample.ascx"
                            InitialRenderBehaviour="Serverside">
                            <ErrorTemplate>
                                Unable to refresh content
                            </ErrorTemplate>
                            <LoadingTemplate>
                                <div style="margin-left: 84px; margin-top: 10px;">
                                    <asp:Image ID="Image1" runat="server" ImageUrl="~/images/loading.gif" />
                                </div>
                                <div style="text-align: center">
                                    Updating...
                                </div>
                            </LoadingTemplate>
                        </iucon:PartialUpdatePanel>
                    </div>
                </td>
                <td>
                    <h1>
                        External refresh sample</h1>
                    <div class="sample">
                        <iucon:PartialUpdatePanel runat="server" ID="PartialUpdatePanel1" UserControlPath="~/ExternalRefreshSample.ascx"
                            InitialRenderBehaviour="None">
                            <ErrorTemplate>
                                Unable to refresh content
                            </ErrorTemplate>
                            <LoadingTemplate>
                                <div style="margin-left: 84px; margin-top: 10px;">
                                    <asp:Image ID="Image1" runat="server" ImageUrl="~/images/loading.gif" />
                                </div>
                                <div style="text-align: center">
                                    Updating...
                                </div>
                            </LoadingTemplate>
                            <InitialTemplate>
                                Nothing useful here until you click on the button
                            </InitialTemplate>
                        </iucon:PartialUpdatePanel>
                    </div>
                    <input type="button" onclick="$find('PartialUpdatePanel1').refresh(); return false;"
                        value="Click to update panel" />
                </td>
                <td>
                    <h1>
                        Parameter sample</h1>
                    <div class="sample">
                        <iucon:PartialUpdatePanel runat="server" ID="PartialUpdatePanel4" UserControlPath="~/ParameterSample.ascx">
                            <Parameters>
                                <iucon:Parameter Name="MyParameter" Value="Hello world" />
                                <iucon:Parameter Name="Counter" Value="0" />
                            </Parameters>
                            <ErrorTemplate>
                                Unable to refresh content
                            </ErrorTemplate>
                        </iucon:PartialUpdatePanel>
                    </div>

                    <script type="text/javascript">
                        var counter = 0;
                        
                        function updateParameterSample() 
                        {
                            $find('PartialUpdatePanel4').get_Parameters()["Counter"] = ++counter;
                            $find('PartialUpdatePanel4').refresh();
                        }
                    </script>

                    <input type="button" onclick="updateParameterSample(); return false;" value="Click to update panel with counter" />
                </td>
            </tr>
            <tr>
                <td>
                    <h1>
                        Long time to update sample</h1>
                    <div class="sample">
                        <iucon:PartialUpdatePanel runat="server" ID="PartialUpdatePanel2" UserControlPath="~/LongTimeUpdateSample.ascx">
                            <ErrorTemplate>
                                Unable to refresh content
                            </ErrorTemplate>
                            <LoadingTemplate>
                                <div style="margin-left: 84px; margin-top: 10px;">
                                    <asp:Image ID="Image1" runat="server" ImageUrl="~/images/loading.gif" />
                                </div>
                                <div style="text-align: center">
                                    Updating...
                                </div>
                            </LoadingTemplate>
                        </iucon:PartialUpdatePanel>
                        Click on one of the other controls while this one is updating.
                    </div>
                </td>
                <td>
                    <h1>
                        DataBinding sample</h1>
                    <div class="sample">
                        <iucon:PartialUpdatePanel runat="server" ID="PartialUpdatePanel3" UserControlPath="~/DataBindingSample.ascx"
                            InitialRenderBehaviour="Serverside" DisplayLoadingAfter="500">
                            <ErrorTemplate>
                                Unable to refresh content
                            </ErrorTemplate>
                            <LoadingTemplate>
                                <div style="margin-left: 84px; margin-top: 10px;">
                                    <asp:Image ID="Image1" runat="server" ImageUrl="~/images/loading.gif" />
                                </div>
                                <div style="text-align: center">
                                    Updating...
                                </div>
                            </LoadingTemplate>
                        </iucon:PartialUpdatePanel>
                    </div>
                </td>
                <td>
                    <h1>
                        Auto refresh sample</h1>
                    <div class="sample">
                        <iucon:PartialUpdatePanel runat="server" ID="PartialUpdatePanel5" UserControlPath="~/ExternalRefreshSample.ascx"
                            AutoRefreshInterval="1000">
                            <ErrorTemplate>
                                Unable to refresh content
                            </ErrorTemplate>
                        </iucon:PartialUpdatePanel>
                    </div>
                </td>
            </tr>
            <tr>
                <td>
                    <h1>
                        JavaScript sample</h1>
                    <div class="sample">
                        <iucon:PartialUpdatePanel runat="server" ID="PartialUpdatePanel6" UserControlPath="~/JavaScriptSample.ascx">
                        </iucon:PartialUpdatePanel>
                    </div>
                </td>
            </tr>
        </table>
    </div>
    <br />
    <div>
        All controls keep their internal state, even if a normal PostBack occurs
        <asp:Button ID="Button1" runat="server" Text="Try a normal PostBack" />
    </div>
    <br />
    <div style="border-top: solid 1px black;">
        <table border="0">
            <tr>
                <td>
                    <asp:Image ID="Image2" runat="server" ImageUrl="~/images/iucon.gif" />
                </td>
                <td>
                    Copyright 2008 by iucon GmbH. All rights reserved.<br />
                    <asp:HyperLink ID="HyperLink1" runat="server" Target="_blank" NavigateUrl="http://www.iucon.com">www.iucon.com</asp:HyperLink>
                </td>
            </tr>
        </table>
    </div>
    </form>
</body>
</html>
