﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI;
using System.Text.RegularExpressions;
using System.Web.Script.Serialization;
using System.Collections.Specialized;
using System.Web;

namespace iucon.web.Controls
{
    internal class ScriptRenderer
    {
        #region ScriptBlock

        class ScriptBlock
        {
            public string Type
            {
                get;
                set;
            }

            public string Script
            {
                get;
                set;
            }
        }

        #endregion

        private string _controlClientID = null;
        private ScriptManager _scriptManager = null;

        public ScriptRenderer(ScriptManager ScriptManager, string ControlClientID)
        {
            _controlClientID = ControlClientID;
            _scriptManager = ScriptManager;
        }

        /// <summary>
        /// Renders all registered JScript elements into a hidden div
        /// The contents of the hidden div are executed with Sys._ScriptLoader
        /// </summary>
        public string GetScriptBlock()
        {
            List<ScriptBlock> list = new List<ScriptBlock>();
            foreach (RegisteredScript script in _scriptManager.GetRegisteredStartupScripts())
                if (script.AddScriptTags)
                    list.Add(AppendScriptBlock("scriptStartupBlock", script));

            foreach (RegisteredScript script in _scriptManager.GetRegisteredClientScriptBlocks())
                if (script.AddScriptTags)
                    list.Add(AppendScriptBlock("scriptBlock", script));

            if (list.Count > 0)
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                StringBuilder sb = new StringBuilder();
                sb.AppendFormat("<div style=\"display: none;\" id=\"{0}_SCRIPTS\">", _controlClientID);
                sb.Append(serializer.Serialize(list));
                sb.Append("</div>");

                return sb.ToString();
            }

            return string.Empty;
        }

        private ScriptBlock AppendScriptBlock(string type, RegisteredScript script)
        {
            ScriptBlock block = new ScriptBlock();
            block.Type = type;
            block.Script = script.Script;

            return block;
        }
    }
}
