﻿// Copyright (c) iucon GmbH. All rights reserved.
// For more information about our work, visit http://www.iucon.com

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.SessionState;

namespace iucon.web.Controls
{
    class PartialUpdatePanelHandler : IHttpHandler, IRequiresSessionState
    {
        #region IHttpHandler Members

        public bool IsReusable
        {
            get { return true; }
        }

        public void ProcessRequest(HttpContext context)
        {
            if (context.Request.Form["__USERCONTROLPATH"] != null)
            {
                try
                {
                    PanelHostPage page = new PanelHostPage(context.Request.Form["__USERCONTROLPATH"], context.Request.Form["__CONTROLCLIENTID"]);

                    ((IHttpHandler)page).ProcessRequest(context);

                    context.Response.Clear();
                    context.Response.Write(page.GetHtmlContent());

                }
                catch (Exception ex)
                {
                    if (ex.InnerException != null)
                    {
                        context.Response.Write(ex.InnerException.Message);
                        context.Response.Write(ex.InnerException.StackTrace);
                    }
                    else
                    {

                        context.Response.Write(ex.Message);
                        context.Response.Write(ex.StackTrace);
                    }
                }
            }
        }

        #endregion
    }
}
