﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Collections.ObjectModel;
using System.Web;
using System.Web.Script.Serialization;

namespace iucon.web.Controls
{
    public class ParameterCollection : Collection<Parameter>
    {
        public string this[string name]
        {
            get
            {
                var result = (from p in Items where p.Name == name select p).FirstOrDefault();
                if (result != null) return result.Value;

                return null;
            }
            set
            {
                var result = (from p in Items where p.Name == name select p).FirstOrDefault();
                if (result != null) 
                    result.Value = value;
            }
        }

        public ParameterCollection()
        {
            if (HttpContext.Current != null &&
                !string.IsNullOrEmpty(HttpContext.Current.Request.Form["__PARAMETERS"]))
            {
                JavaScriptSerializer serializer = new JavaScriptSerializer();
                Parameter[] parameters = serializer.Deserialize<Parameter[]>(HttpContext.Current.Request.Form["__PARAMETERS"]);                
                if (parameters != null && parameters.Length > 0)
                {
                    foreach (Parameter p in parameters)
                        Add(p);
                }
            }
        }
    }
}
