﻿<%@ Page Language="C#" AutoEventWireup="true"  CodeFile="Default.aspx.cs" Inherits="_Default" Theme="MyTheme" %>
<%@ Register TagPrefix="myControls" Assembly="ListViewSort" Namespace="SanibelLogic.ListView" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Test ListViewSort</title>
</head>
<body>
    <form id="form1" runat="server">
    <div id="MasterContainer">
		<myControls:ListViewSort ID="listViewSort" 
			DataSourceID="ObjMenu" 
			DataKeyNames="Name"
			SortExpressionDefault="Name"
			SortDirectionDefault="Ascending"
			runat="server">
			<LayoutTemplate>
				<table runat="server" 
					class="listViewGrid"
					cellspacing="0"
					border="0">
					<tr>
						<th>
							<myControls:ListViewSortColumnHeader runat="server"
								Key="Name"
								Text="Food Name" />
						</th>
						<th>
							<myControls:ListViewSortColumnHeader runat="server"
								Key="Price"
								Text="Price" />
						</th>
						<th>
							<myControls:ListViewSortColumnHeader runat="server"	
								Key="Description"
								Text="Description" />
						</th>
						<th>
							<myControls:ListViewSortColumnHeader runat="server"
								Key="Calories"
								Text="Calories" />
						</th>
					</tr>
					
					<tr runat="server" id="itemPlaceholder" />
				
				</table>
				<asp:DataPager ID="dataPager" runat="server">
					<Fields>
						<asp:NumericPagerField ButtonCount="10"
							NextPageText="..."
							PreviousPageText="..." />     
					</Fields>
				</asp:DataPager>
			</LayoutTemplate>
			<ItemTemplate>
				<tr class="<%# ((ListViewDataItem)Container).DisplayIndex % 2 == 0 ? "itemRow" : "altItemRow" %>">
					<td align="left" style="width: 200px;">
						<asp:Label runat="server" 
							Text='<%# Eval("Name") %>' />
					</td>
					<td align="right" style="width: 100px;">   
						<asp:Label runat="server" 
							Text='<%# Eval("Price") %>' />
					</td>
					<td align="left" style="width: 400px;">
						<asp:Label runat="server" 
							Text='<%# Eval("Description") %>' />
					</td>
					<td align="right" style="width: 100px;">
						<asp:Label runat="server" 
							Text='<%# Eval("Calories") %>' />
					</td>
				</tr>
			</ItemTemplate>
		</myControls:ListViewSort>	
									        
		<asp:ObjectDataSource ID="ObjMenu" runat="server" 
			EnablePaging="true"
			SelectMethod="GetRows" 
			SelectCountMethod="GetRowCount" 
			TypeName="SanibelLogic.MenuDataSource.DataIO" 
			DataObjectTypeName="SanibelLogic.MenuDataSource.Elements"
			MaximumRowsParameterName="MaximumRows" 
			StartRowIndexParameterName="StartRowIndex"				
			SortParameterName="SortExpression">
			<SelectParameters>
				<asp:Parameter Name="SortExpression" 
					Type="String" />
				<asp:Parameter Name="MaximumRows" 
					Type="Int32" />
				<asp:Parameter Name="StartRowIndex" 
					Type="Int32" />
			</SelectParameters>
		</asp:ObjectDataSource>
			
    </div>
    </form>
</body>
</html>
