﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections;
using System.Collections.Generic;
using System.Text.RegularExpressions;

/// <summary>
/// Summary description for SortMe
/// </summary>
/// 
namespace SanibelLogic.MenuDataSource
{
    // Comparer class - used in ArrayList.Sort
    public class SortMe : IComparer
    {
        #region Private Properties
        private string m_strSortExpression = string.Empty;
        #endregion

        #region Private Methods
        private int CompareTo(object x,
            object y,
            bool bDescending)
        {
            int iRetVal = 0;

            if ((x != null) ||
                (y != null))
            {
                object objTest = x;
                if (x == null)
                {
                    objTest = y;
                }

                switch (objTest.GetType().ToString())
                {
                    case "System.String":
                        string strValueX = string.Empty;
                        if (x != null)
                        {
                            strValueX = (string)x;
                        }

                        string strValueY = string.Empty;
                        if (y != null)
                        {
                            strValueY = (string)y;
                        }

                        if (bDescending == true)
                        {
                            iRetVal = strValueY.CompareTo(strValueX);
                        }
                        else
                        {
                            iRetVal = strValueX.CompareTo(strValueY);
                        }
                        break;
                    case "System.Int32":
                        Int32 iValueX = 0;
                        if (x != null)
                        {
                            iValueX = (Int32)x;
                        }

                        Int32 iValueY = 0;
                        if (y != null)
                        {
                            iValueY = (Int32)y;
                        }

                        if (bDescending == true)
                        {
                            iRetVal = iValueY.CompareTo(iValueX);
                        }
                        else
                        {
                            iRetVal = iValueX.CompareTo(iValueY);
                        }
                        break;
                    case "System.Int64":
                        Int64 i6ValueX = 0;
                        if (x != null)
                        {
                            i6ValueX = (Int64)x;
                        }

                        Int64 i6ValueY = 0;
                        if (y != null)
                        {
                            i6ValueY = (Int64)y;
                        }

                        if (bDescending == true)
                        {
                            iRetVal = i6ValueY.CompareTo(i6ValueX);
                        }
                        else
                        {
                            iRetVal = i6ValueX.CompareTo(i6ValueY);
                        }
                        break;
                    case "System.Decimal":
                        decimal dValueX = 0;
                        if (x != null)
                        {
                            dValueX = (decimal)x;
                        }

                        decimal dValueY = 0;
                        if (y != null)
                        {
                            dValueY = (decimal)y;
                        }

                        if (bDescending == true)
                        {
                            iRetVal = dValueY.CompareTo(dValueX);
                        }
                        else
                        {
                            iRetVal = dValueX.CompareTo(dValueY);
                        }
                        break;
                    case "System.DateTime":
                        DateTime dtValueX = new DateTime();
                        if (x == null)
                        {
                            dtValueX = DateTime.MinValue;
                        }
                        else
                        {
                            dtValueX = (DateTime)x;
                        }

                        DateTime dtValueY = new DateTime();
                        if (y == null)
                        {
                            dtValueY = DateTime.MinValue;
                        }
                        else
                        {
                            dtValueY = (DateTime)y;
                        }

                        if (bDescending == true)
                        {
                            iRetVal = dtValueY.CompareTo(dtValueX);
                        }
                        else
                        {
                            iRetVal = dtValueX.CompareTo(dtValueY);
                        }
                        break;
                    case "System.Boolean":
                        bool bValueX = false;
                        if (x != null)
                        {
                            bValueX = (bool)x;
                        }

                        bool bValueY = false;
                        if (y != null)
                        {
                            bValueY = (bool)y;
                        }

                        if (bDescending == true)
                        {
                            iRetVal = bValueY.CompareTo(bValueX);
                        }
                        else
                        {
                            iRetVal = bValueX.CompareTo(bValueY);
                        }
                        break;
                    default:
                        break;
                }
            }

            return iRetVal;
        }
        #endregion

        #region Constructor
        public SortMe(string SortExpression)
        {
            m_strSortExpression = SortExpression;
        }
        #endregion

        #region Public Methods
        public int Compare(object x, object y)
        {
            int iRetVal = 0;

            bool bDescending = false;
            string strSortExpression = m_strSortExpression;

            Regex reDESC = new Regex("DESC?");
            Match mtDESC = reDESC.Match(m_strSortExpression);
            if (mtDESC.Success == true)
            {
                bDescending = true;
                strSortExpression = m_strSortExpression.Substring(0, m_strSortExpression.Length - 5);
            }
            else
            {
                Regex reASC = new Regex("ASC?");
                Match mtASC = reASC.Match(m_strSortExpression);
                if (mtASC.Success == true)
                {
                    bDescending = false;
                    strSortExpression = m_strSortExpression.Substring(0, m_strSortExpression.Length - 4);
                }
            }

            Elements X = (Elements)x;
            Elements Y = (Elements)y;

            switch (strSortExpression)
            {
                case "Name":
                    iRetVal = CompareTo(X.Name, Y.Name, bDescending);
                    break;
                case "Price":
                    iRetVal = CompareTo(X.Price, Y.Price, bDescending);
                    break;
                case "Description":
                    iRetVal = CompareTo(X.Description, Y.Description, bDescending);
                    break;
                case "Calories":
                    iRetVal = CompareTo(X.Calories, Y.Calories, bDescending);
                    break;
                default:
                    iRetVal = CompareTo(X.Name, Y.Name, bDescending);
                    break;
            }

            return iRetVal;
        }
        #endregion
    }
}