﻿using System;
using System.Data;
using System.Configuration;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;
using System.Collections;
using System.Collections.Generic;
using System.Xml;

/// <summary>
/// Summary description for DataIO
/// </summary>
namespace SanibelLogic.MenuDataSource
{
    public class DataIO
    {
        #region Private Properties
        private const string m_SessionKeyDataSourceRowCount = "_DataSourceRowCount";
        #endregion

        #region Private Methods
        
        private List<Elements> SortSelectList(ref List<Elements> list,
            string SortExpression)
        {
            List<Elements> newList = new List<Elements>();

            ArrayList sortedList = new ArrayList();

            foreach (Elements elements in list)
            {
                sortedList.Add(elements);
            }

            sortedList.Sort(new SortMe(SortExpression));

            foreach (Elements elements in sortedList)
            {
                newList.Add(elements);
            }

            return newList;
        }

        private List<Elements> GetPagingRows(List<Elements> list,
            int iStartRowIndex,
            int iMaximumRows)
        {
            int iNewStartRowIndex = iStartRowIndex;

            List<Elements> newList = new List<Elements>();
            int j = 0;
            for (int i = 0; i < list.Count; i++)
            {
                if (i >= iNewStartRowIndex)
                {
                    newList.Add(list[i]);
                    j++;
                    if (j == iMaximumRows)
                    {
                        break;
                    }
                }
            }
            return newList;
        }
        #endregion

        #region Constructor
        public DataIO()
        {
        }
        #endregion

        #region Public Methods
        public List<Elements> GetRows(string SortExpression,
            Int32 MaximumRows,
            Int32 StartRowIndex)
        {
            if (MaximumRows > 0)
            {
                List<Elements> list = new List<Elements>();

                XmlDocument xml = new XmlDocument();
                string strXmlFilePath = System.Web.HttpContext.Current.Request.MapPath("menu.xml");
                xml.Load(strXmlFilePath); 
                XmlNodeList nodeList = xml.DocumentElement.SelectNodes("/breakfast_menu/food");
                foreach (XmlNode node in nodeList)
                {
                    Elements elements = new Elements();
                    elements.Name = node.SelectSingleNode("name").InnerText;
                    elements.Price = Convert.ToDecimal(node.SelectSingleNode("price").InnerText);
                    elements.Description = node.SelectSingleNode("description").InnerText;
                    elements.Calories = Convert.ToInt32(node.SelectSingleNode("calories").InnerText);
                    list.Add(elements);
                }

                string strSortExpression = "Name";
                if (SortExpression.Length > 0)
                {
                    strSortExpression = SortExpression;
                }

                List<Elements> sortedList = SortSelectList(ref list, strSortExpression);
                System.Web.HttpContext.Current.Session[m_SessionKeyDataSourceRowCount] = sortedList.Count;
                return GetPagingRows(sortedList, StartRowIndex, MaximumRows);
            }
            else
            {
                throw new Exception(this.GetType().ToString() + " is not enabled for custom paging");
            }
        }

        public int GetRowCount(string SortExpression,
            Int32 MaximumRows,
            Int32 StartRowIndex)
        {
            return (int)System.Web.HttpContext.Current.Session[m_SessionKeyDataSourceRowCount];
        }
        #endregion
    }
}