using System;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Collections;
using System.Collections.Specialized;
using System.Collections.Generic;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;
using System.ComponentModel;

namespace SanibelLogic.ListView
{
	#region ListViewSortColumnHeader Class
    /// <summary>
    /// ListView Sort Column Header
    /// </summary>
	[
        ToolboxData("<{0}:ListViewSortColumnHeader runat=server></{0}:ListViewSortColumnHeader>"),
        ParseChildren(true),
        PersistChildren(true)
	]
    public class ListViewSortColumnHeader : CompositeControl
	{
		#region Constructor
        /// <summary>
        /// Constructor.
        /// </summary>
        public ListViewSortColumnHeader()
		{

		}
		#endregion

        #region Private Properties  
      
        // ViewState veriables
        private const string _Text = "_Text";
        private const string _Key = "_Key";
        private const string _ImageUrlAscending = "_ImageUrlAscending";
        private const string _ImageUrlDescending = "_ImageUrlDescending";
        private const string _ImageObjectAttributes = "_ImageObjectAttributes";

        // Embedded resource variables
        private const string m_EmbeddedResourcesPrefix = "SanibelLogic.ListView.Images.SortDirectionArrows.Red.";
        private const string m_ImageUrlAscendingFileName = "DownArrow-14pt.png";
        private const string m_ImageUrlDescendingFileName = "UpArrow-14pt.png";

        #endregion

        #region Private Properties
        private string ImageUrlAscendingX
        {
            get
            {
                string strImageUrl = string.Empty;
                if (ImageUrlAscending.Length == 0)
                {
                    Control parentControl = Helpers.GetParentByType(this, typeof(ListViewSort));
                    if (parentControl == null)
                    {
                        throw new Exception(this.GetType().ToString() + " used outside of " + typeof(ListViewSort).ToString());
                    }
                    else
                    {
                        ListViewSort listViewSort = (ListViewSort)parentControl;
                        strImageUrl = listViewSort.ImageUrlAscending;
                    }
                    if (strImageUrl.Length == 0)
                    {
                        strImageUrl = Page.ClientScript.GetWebResourceUrl(this.GetType(),
                            m_EmbeddedResourcesPrefix + m_ImageUrlAscendingFileName);
                    }
                }
                else
                {
                    strImageUrl = ImageUrlAscending;
                }

                return strImageUrl;
            }
        }

        private string ImageUrlDescendingX
        {
            get
            {
                string strImageUrl = string.Empty;
                if (ImageUrlDescending.Length == 0)
                {
                    Control parentControl = Helpers.GetParentByType(this, typeof(ListViewSort));
                    if (parentControl == null)
                    {
                        throw new Exception(this.GetType().ToString() + " used outside of " + typeof(ListViewSort).ToString());
                    }
                    else
                    {
                        ListViewSort listViewSort = (ListViewSort)parentControl;
                        strImageUrl = listViewSort.ImageUrlDescending;
                    }
                    if (strImageUrl.Length == 0)
                    {
                        strImageUrl = Page.ClientScript.GetWebResourceUrl(this.GetType(),
                            m_EmbeddedResourcesPrefix + m_ImageUrlDescendingFileName);
                    }
                }
                else
                {
                    strImageUrl = ImageUrlDescending;
                }

                return strImageUrl;
            }
        }
        #endregion

        #region Public Properties

        /// <summary>
        /// Text.
        /// </summary>
        public string Text
        {
            get
            {
                return (this.ViewState[_Text] == null) ? "" : (string)this.ViewState[_Text];
            }
            set
            {
                this.ViewState[_Text] = value;
            }
        }

        /// <summary>
        /// Key.
        /// </summary>
        public string Key
        {
            get
            {
                return (this.ViewState[_Key] == null) ? "" : (string)this.ViewState[_Key];
            }
            set
            {
                this.ViewState[_Key] = value;
            }
        }

        /// <summary>
        /// ImageUrlAscending.
        /// </summary>
        public string ImageUrlAscending
        {
            get
            {
                return (this.ViewState[_ImageUrlAscending] == null) ? string.Empty : (string)this.ViewState[_ImageUrlAscending];
            }
            set
            {
                this.ViewState[_ImageUrlAscending] = value;
            }
        }

        /// <summary>
        /// ImageUrlDescending.
        /// </summary>
        public string ImageUrlDescending
        {
            get
            {
                return (this.ViewState[_ImageUrlDescending] == null) ? string.Empty : (string)this.ViewState[_ImageUrlDescending];
            }
            set
            {
                this.ViewState[_ImageUrlDescending] = value;
            }
        }
     	#endregion

        #region Protected Methods

        /// <summary>
        /// DataBind.
        /// </summary>
        public override void DataBind()
        {
            base.DataBind();
            EnsureChildControls();
        }

        /// <summary>
        /// CreateChildControls.
        /// </summary>
		protected override void CreateChildControls()
		{
            Controls.Clear();

            LinkButton lnkButton = new LinkButton();
            lnkButton.ID = "btn" + Key;
            lnkButton.CommandName = "Sort";
            lnkButton.CommandArgument = Key;
            lnkButton.Text = Text;

            Controls.Add(lnkButton);

            if (ViewState[_ImageObjectAttributes] != null)
            {
                ImageViewState imageViewState = (ImageViewState)ViewState[_ImageObjectAttributes];
                Image image = new Image();
                image.ID = "img" + imageViewState.SortExpression;
                image.BorderStyle = BorderStyle.None;
                image.ImageUrl = imageViewState.ImageUrl;
                if (imageViewState.SortDirection == SortDirection.Ascending)
                {
                    image.ToolTip = "Ascending";
                    image.AlternateText = "Ascending";
                }
                else
                {
                    image.ToolTip = "Descending";
                    image.AlternateText = "Descending";
                }
                Controls.Add(image);
            }
		}
		#endregion

        #region Public Methods
        public bool HasSortDirectionIndicator()
        {
            bool bResult = false;

            List<Control> controls = Helpers.GetControlsByType(this, typeof(Image));
            if (controls.Count > 0)
            {
                bResult = true;
            }

            return bResult;
        }

        public void ResetSortDirectionIndicator()
        {
            List<Control> controls = Helpers.GetControlsByType(this, typeof(Image));
            foreach (Control control in controls)
            {
                this.Controls.Remove(control);
                ViewState[_ImageObjectAttributes] = null;
            }
        }


        public void SetSortDirectionIndicator(string sortExpression, 
            SortDirection sortDirection)
        {
            Image image = new Image();
            image.ID = "img" + sortExpression;
            image.BorderStyle = BorderStyle.None;

            ImageViewState imageViewState = new ImageViewState();
            imageViewState.SortDirection = sortDirection;
            imageViewState.SortExpression = sortExpression;

            if (sortDirection == SortDirection.Ascending)
            {
                image.ImageUrl = ImageUrlAscendingX;
                image.ToolTip = "Ascending";
                image.AlternateText = "Ascending";
                this.Controls.Add(image);
            }
            else
            {
                image.ImageUrl = ImageUrlDescendingX;
                image.ToolTip = "Descending";
                image.AlternateText = "Descending";
                this.Controls.Add(image);
            }

            imageViewState.ImageUrl = image.ImageUrl;
            ViewState[_ImageObjectAttributes] = imageViewState;
        }
        #endregion

    }
	#endregion
}