using System;
using System.ComponentModel;
using System.Collections.Generic;
using System.Text;
using System.Text.RegularExpressions;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Drawing.Design;

namespace SanibelLogic.ListView
{
    /// <summary>
    /// ListView Inherited Custom Control for sorting of column headers.
    /// </summary>
    [
        ToolboxData("<{0}:ListViewSort runat=server></{0}:ListViewSort>"),
        ParseChildren(true),
        PersistChildren(true)
    ]
    public class ListViewSort : System.Web.UI.WebControls.ListView
    {
        #region Private Properties

        // ViewState veriables
        private const string _ImageUrlAscending = "_ImageUrlAscending";
        private const string _ImageUrlDescending = "_ImageUrlDescending";
        private const string _SortExpressionDefault = "_SortExpressionDefault";
        private const string _SortDirectionDefault = "_SortDirectionDefault";
        #endregion

        #region Public Properties
        /// <summary>
        /// ImageUrlAscending.
        /// </summary>
        [
        Description("Ascending Sort Direction graphic image file."),
        Category("Extensions"),
        Editor(typeof(System.Web.UI.Design.UrlEditor), typeof(UITypeEditor))
        ]
        public string ImageUrlAscending
        {
            get
            {
                return (this.ViewState[_ImageUrlAscending] == null) ? string.Empty : (string)this.ViewState[_ImageUrlAscending];
            }
            set
            {
                this.ViewState[_ImageUrlAscending] = value;
            }
        }

        /// <summary>
        /// ImageUrlDescending.
        /// </summary>
        [
        Description("Descending Sort Direction graphic image file."),
        Category("Extensions"),
        Editor(typeof(System.Web.UI.Design.UrlEditor), typeof(UITypeEditor))
        ]
        public string ImageUrlDescending
        {
            get
            {
                return (this.ViewState[_ImageUrlDescending] == null) ? string.Empty : (string)this.ViewState[_ImageUrlDescending];
            }
            set
            {
                this.ViewState[_ImageUrlDescending] = value;
            }
        }

        /// <summary>
        /// SortExpressionDefault.
        /// </summary>
        [
        Description("Sort Expression default value."),
        Category("Extensions")
        ]
        public string SortExpressionDefault
        {
            get
            {
                return (this.ViewState[_SortExpressionDefault] == null) ? string.Empty : (string)this.ViewState[_SortExpressionDefault];
            }
            set
            {
                this.ViewState[_SortExpressionDefault] = value;
            }
        }

        /// <summary>
        /// SortDirectionDefault.
        /// </summary>
        [
        Description("Sort Direction default value."),
        Category("Extensions")
        ]
        public SortDirection SortDirectionDefault
        {
            get
            {
                return (this.ViewState[_SortDirectionDefault] == null) ? SortDirection.Ascending : (SortDirection)this.ViewState[_SortDirectionDefault];
            }
            set
            {
                this.ViewState[_SortDirectionDefault] = value;
            }
        }
        #endregion

        #region Protected Event Handlers
        protected override void OnDataBound(EventArgs e)
        {
            if (base.SortExpression.Length == 0)
            {
                if (SortExpressionDefault.Length > 0)
                {
                    base.Sort(SortExpressionDefault, SortDirectionDefault);
                }
            }

            List<Control> controls = Helpers.GetControlsByType(this, typeof(ListViewSortColumnHeader));
            foreach (Control control in controls)
            {
                ListViewSortColumnHeader header = (ListViewSortColumnHeader)control;
                if (header.HasSortDirectionIndicator() == true)
                {
                    header.ResetSortDirectionIndicator();
                }
            }

            foreach (Control control in controls)
            {
                ListViewSortColumnHeader header = (ListViewSortColumnHeader)control;
                if (header.Key == base.SortExpression)
                {
                    header.SetSortDirectionIndicator(base.SortExpression, base.SortDirection);
                    break;
                }
            }

            base.OnDataBound(e);
        }
        #endregion
    }
}