﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web;
using System.Web.UI;

namespace SanibelLogic.ListView
{
    public class Helpers
    {
        public static List<Control> GetControlsByType(
            Control ctl,
            Type type)
        {
            List<Control> controls = new List<Control>();

            foreach (Control childCtl in ctl.Controls)
            {
                if (childCtl.GetType() == type)
                {
                    controls.Add(childCtl);
                }

                if (childCtl.Controls != null)
                {
                    List<Control> childControls = GetControlsByType(childCtl, type);
                    foreach (Control childControl in childControls)
                    {
                        controls.Add(childControl);
                    }
                }
            }

            return controls;
        }

        public static Control GetParentByType(
            Control ctl,
            Type type)
        {
            Control parent = ctl.Parent;

            while (parent != null)
            {
                if (parent.GetType() == type)
                {
                    break;
                }

                if (parent.Parent == null)
                {
                    parent = null;
                    break;
                }
                else
                {
                    parent = parent.Parent;
                }
            }

            return parent;
        }
    }
}
