/*
Copyright  2005 - 2006 Annpoint, s.r.o.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

-------------------------------------------------------------------------

NOTE: Reuse requires the following acknowledgement (see also NOTICE):
This product includes DayPilot (http://www.daypilot.org) developed by Annpoint, s.r.o.
*/


using System;
using System.Data;
using System.Globalization;
using System.Threading;
using DayPilot.Web.Ui;

namespace DayPilotDemo
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class _Default : System.Web.UI.Page
	{
		protected DayPilot.Web.Ui.DayPilotCalendar DayPilotCalendar1;
		protected System.Web.UI.WebControls.Label Label1;
		protected System.Web.UI.WebControls.LinkButton LinkButtonSwitch1224;
		protected System.Web.UI.WebControls.LinkButton LinkButton1;
		protected System.Web.UI.WebControls.LinkButton LinkButton2;
		protected System.Web.UI.WebControls.LinkButton LinkButton3;
		protected System.Web.UI.WebControls.Calendar Calendar1;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			Thread.CurrentThread.CurrentCulture = new CultureInfo("en-US");

			if (!IsPostBack)
			{
				this.Calendar1.SelectedDate = Day;
				this.Calendar1.VisibleDate = Day;
				this.DayPilotCalendar1.StartDate = Day;
				this.DayPilotCalendar1.EndDate = Day;
				
				DataBind();
			}
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Calendar1.DayRender += new System.Web.UI.WebControls.DayRenderEventHandler(this.Calendar1_DayRender);
			this.LinkButtonSwitch1224.Click += new System.EventHandler(this.LinkButtonSwitch1224_Click);
			this.LinkButton1.Click += new System.EventHandler(this.LinkButton1_Click);
			this.LinkButton2.Click += new System.EventHandler(this.LinkButton2_Click);
			this.DayPilotCalendar1.FreeTimeClick += new DayPilot.Web.Ui.FreeClickDelegate(this.DayPilotCalendar1_FreeTimeClick);
			this.DayPilotCalendar1.EventClick += new DayPilot.Web.Ui.EventClickDelegate(this.DayPilotCalendar1_EventClick);
			this.LinkButton3.Click += new System.EventHandler(this.LinkButton3_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void Calendar1_DayRender(object sender, System.Web.UI.WebControls.DayRenderEventArgs e)
		{
			string fontWeight = "normal";
			if (isThereEvent(e.Day.Date))
				fontWeight = "bold";

			string color = "black";
			if (e.Day.IsOtherMonth)
				color = this.Calendar1.OtherMonthDayStyle.ForeColor.Name;

			e.Cell.Text = String.Format("<a href='Default.aspx?day={0:d}' style='color: " + color + ";text-decoration:none; font-weight:" + fontWeight + "'>{1}</a>", e.Day.Date, e.Day.Date.Day);		
		}

		protected DateTime Day
		{
			get
			{
				if (Request.Params["day"] != null)
				{
					try
					{
						return Convert.ToDateTime(Request.Params["day"]);
					}
					catch
					{
						// do nothing, continue to return today
					}
				}
				return DateTime.Now;
			}
		}


		protected DataTable getData
		{
			get
			{
				DataTable dt;
				dt= new DataTable();
				dt.Columns.Add("start", typeof(DateTime));
				dt.Columns.Add("end", typeof(DateTime));
				dt.Columns.Add("name", typeof(string));
				dt.Columns.Add("id", typeof(string));
	
				DataRow dr;
	
				dr = dt.NewRow();
				dr["id"] = 0;
				dr["start"] = Convert.ToDateTime("15:30").AddDays(1);
				dr["end"] = Convert.ToDateTime("16:30").AddDays(1);
				dr["name"] = "Partner conf. call";
				dt.Rows.Add(dr);
	
				dr = dt.NewRow();
				dr["id"] = 1;
				dr["start"] = Convert.ToDateTime("16:00").AddDays(1);
				dr["end"] = Convert.ToDateTime("17:00").AddDays(1);
				dr["name"] = "Important event";
				dt.Rows.Add(dr);
	
				dr = dt.NewRow();
				dr["id"] = 2;
				dr["start"] = Convert.ToDateTime("16:00");
				dr["end"] = Convert.ToDateTime("18:00");
				dr["name"] = "Webinar";
				dt.Rows.Add(dr);
	
				dr = dt.NewRow();
				dr["id"] = 3;
				dr["start"] = Convert.ToDateTime("16:30");
				dr["end"] = Convert.ToDateTime("17:30");
				dr["name"] = "Sales Dept. Meeting Once Again";
				dt.Rows.Add(dr);
	
				dr = dt.NewRow();
				dr["id"] = 4;
				dr["start"] = Convert.ToDateTime("8:00");
				dr["end"] = Convert.ToDateTime("9:00");
				dr["name"] = "Breakfest";
				dt.Rows.Add(dr);

				dr = dt.NewRow();
				dr["id"] = 5;
				dr["start"] = Convert.ToDateTime("22:00");
				dr["end"] = Convert.ToDateTime("6:00").AddDays(1);
				dr["name"] = "Overnight event";
				dt.Rows.Add(dr);


				dr = dt.NewRow();
				dr["id"] = 6;
				dr["start"] = Convert.ToDateTime("11:00").AddDays(3);
				dr["end"] = Convert.ToDateTime("13:00").AddDays(3);
				dr["name"] = "Lunch";
				dt.Rows.Add(dr);
				
				return dt;

			}
			
		}


		/// <summary>
		/// This method return true if the specified day contains any event. It is hardcoded for the demonstration purposes; you would normally want to replace it with a database-driven code.
		/// </summary>
		/// <param name="date"></param>
		/// <returns></returns>
		private bool isThereEvent(DateTime date)
		{
			DateTime today = DateTime.Now;
			DateTime tomorrow = today.AddDays(1);
			DateTime anotherDay = today.AddDays(3);

			// there are events today
			if ((date.DayOfYear == today.DayOfYear) && (date.Year == today.Year))
				return true;

			// there are events tomorrow
			if ((date.DayOfYear == tomorrow.DayOfYear) && (date.Year == tomorrow.Year))
				return true;

			// there are events on another day
			if ((date.DayOfYear == anotherDay.DayOfYear) && (date.Year == anotherDay.Year))
				return true;

			return false;
		}

		private void DayPilotCalendar1_FreeTimeClick(System.DateTime start)
		{
			Label1.Text = "Selected time: " + start.ToString("s");
		}

		private void LinkButtonSwitch1224_Click(object sender, System.EventArgs e)
		{
			if (this.DayPilotCalendar1.TimeFormat == TimeFormat.Clock12Hours)
				this.DayPilotCalendar1.TimeFormat = TimeFormat.Clock24Hours;
			else
				this.DayPilotCalendar1.TimeFormat = TimeFormat.Clock12Hours;
		}

		private void LinkButton1_Click(object sender, System.EventArgs e)
		{
			if (this.DayPilotCalendar1.NonBusinessHours == NonBusinessHoursBehavior.AlwaysVisible)
				this.DayPilotCalendar1.NonBusinessHours = NonBusinessHoursBehavior.HideIfPossible;
			else
				this.DayPilotCalendar1.NonBusinessHours = NonBusinessHoursBehavior.AlwaysVisible;
		}

		private void LinkButton2_Click(object sender, System.EventArgs e)
		{
			if (this.DayPilotCalendar1.HourHeight == 40)
				this.DayPilotCalendar1.HourHeight = 30;
			else
				this.DayPilotCalendar1.HourHeight = 40;
		}

		private void LinkButton3_Click(object sender, System.EventArgs e)
		{
			if (this.DayPilotCalendar1.FreetimeClickHandling == UserActionHandling.JavaScript)
			{
				this.DayPilotCalendar1.FreetimeClickHandling = UserActionHandling.PostBack;
				this.DayPilotCalendar1.EventClickHandling = UserActionHandling.PostBack;
			}
			else
			{
				this.DayPilotCalendar1.FreetimeClickHandling = UserActionHandling.JavaScript;
				this.DayPilotCalendar1.EventClickHandling = UserActionHandling.JavaScript;
			}

		}

		private void DayPilotCalendar1_EventClick(string pk)
		{
			Label1.Text = "Selected event: " + pk;
		}
	}
}
