using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System;
using System.Web;
using System.Drawing.Drawing2D;
using System.Drawing;
using System.Collections.Generic;
using ImageTemplateNet;

/// <summary>
/// Shows the elements that exist in the template and lets the user test them
/// </summary>
public partial class TestTemplate : System.Web.UI.Page
{
    ImageTemplate template;

    protected void Page_Load(object sender, EventArgs e)
    {
        template = ImageTemplateManager.Instance.GetTemplate(Request["templateId"]);

        if (!IsPostBack)
        {
            if (template != null)
            {
                labID.Text = template.Id;
                labWidth.Text = template.Width.ToString();
                labHeight.Text = template.Height.ToString();
                labBackgroundColor.Text = template.BackgroundColor.ToString();
                labImageFormat.Text = template.ImageFormat.ToString();
                labGraphicsUnit.Text = template.GraphicsUnit.ToString();

                
                TreeNode rootNode = new TreeNode("Elements");
                templateElementTv.Nodes.Add(rootNode);

                AddElements(rootNode, template.Elements);


                //templateElementRepeater.DataSource = template.Elements;
                //templateElementRepeater.DataBind();
                System.Text.StringBuilder sb = new System.Text.StringBuilder();
                sb.Append(ResolveClientUrl("~/TemplateImageGenerator.axd?template="));
                sb.Append(template.Id);

                Dictionary<string,string> typicalUrlParameters = GetTypicalUrlParameters(template.Elements);
                foreach (KeyValuePair<string, string> val in typicalUrlParameters)
                {
                    sb.Append("&");
                    sb.Append(val.Key);
                    sb.Append("=");
                    sb.Append(HttpUtility.UrlEncode(val.Value));                    
                }

                txtImageUrl.Text = sb.ToString();
            }
        }
    }


    private Dictionary<string, string> GetTypicalUrlParameters(List<TemplateElementHolder> holders)
    {
        Dictionary<string, string> output = new Dictionary<string, string>();
        foreach (TemplateElementHolder holder in holders)
        {
            if (holder.Config is TextElementConfig) {
                TextElementConfig txtConfig = (TextElementConfig) holder.Config;
                output[holder.Config.Id + ".Text"] = txtConfig.Text;
            }
            else if (holder.Config is ImageElementConfig)
            {
                ImageElementConfig imgConfig = (ImageElementConfig)holder.Config;
                if (!String.IsNullOrEmpty(imgConfig.ImageUrl))
                {
                    if (imgConfig.ImageUrl.Contains("$param1$"))
                    {
                        output[holder.Config.Id + ".Parameters[0]"] = "partOfFileName";
                    }
                }
            }
            // Add the sub elements
            Dictionary<string, string> subElementOutput =  GetTypicalUrlParameters(holder.ChildElements);
            foreach (KeyValuePair<string, string> val in subElementOutput)
            {
                output[val.Key] = val.Value;
            }
        }
        return output;
    }

    private void AddElements(TreeNode rootNode, List<TemplateElementHolder> holders)
    {
        foreach (TemplateElementHolder holder in holders)
        {
            AddElements(rootNode, holder);
        }
    }
                

    private void AddElements(TreeNode rootNode, TemplateElementHolder holder)
    {
        TreeNode node = new TreeNode(holder.Config.Id);
        rootNode.ChildNodes.Add(node);

        AddProperties(node, holder);

        if (holder.ChildElements.Count > 0)
        {
            TreeNode elementsNode = new TreeNode("Elements");
            node.ChildNodes.Add(elementsNode);
            node = elementsNode;
        }


        node.CollapseAll();
        
        foreach (TemplateElementHolder childHolder in holder.ChildElements)
        {

            AddElements(node, childHolder);            
        }
    }

    private void AddProperties(TreeNode rootNode, TemplateElementHolder holder)
    {
        TreeNode propertiesNode = new TreeNode("Properties");

        Type t = holder.Config.GetType();
        System.Reflection.PropertyInfo[] properties = t.GetProperties();
        foreach (System.Reflection.PropertyInfo p in properties)
        {
            object val = p.GetValue(holder.Config,null);
            if (val == null) {
                val = "null";
            }
            propertiesNode.ChildNodes.Add( new TreeNode(p.Name + " = " + val.ToString(),""));
        }
        propertiesNode.CollapseAll();
        rootNode.ChildNodes.Add(propertiesNode);
    }

    protected void templateElementTv_OnSelectedNodeChanged(object sender, EventArgs e)
    {
        TreeNode node = templateElementTv.SelectedNode;
        TemplateElementHolder holder = template.GetElementHolderById(node.Text);
        
        if (holder != null)
        {
            Session["selectedObject"] = holder.Config;
            //pg1.SelectedObject = holder.Config;
        }

    }

    protected void templateElementRepeater_ItemDataBound(object sender, RepeaterItemEventArgs e)
    {
        if (e.Item.ItemType == ListItemType.Item || e.Item.ItemType == ListItemType.AlternatingItem)
        {

        }
    }

}
